/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.ashxml;

import java.util.HashMap;
import java.util.Vector;

public class XmlNode {
    private String name = null;
    private XmlNode parent = null;
    private String value = null;
    private Vector children = new Vector();
    private HashMap attributes = new HashMap();

    public XmlNode(String name, XmlNode parent) {
        this.parent = parent;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public XmlNode findChild(String name) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!this.getChild(i).getName().equals(name)) continue;
            return this.getChild(i);
        }
        return null;
    }

    public XmlNode getParent() {
        return this.parent;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public XmlNode getChild(int index) {
        return (XmlNode)this.children.get(index);
    }

    public void addChild(XmlNode child) {
        this.children.add(child);
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name.toLowerCase(), value);
    }

    public double getDoubleAttribute(String name) {
        String attribute = this.getAttribute(name);
        if (attribute.equals("")) {
            return 0.0;
        }
        try {
            return Double.parseDouble(attribute);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public String getAttribute(String name) {
        String key = name.toLowerCase();
        if (this.attributes.containsKey(key)) {
            return (String)this.attributes.get(key);
        }
        return "";
    }

    public int getIntAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            try {
                return Integer.parseInt((String)this.attributes.get(name));
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
        return 0;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Vector findAllChildren(String name) {
        Vector<XmlNode> result = new Vector<XmlNode>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!this.getChild(i).getName().equals(name)) continue;
            result.add(this.getChild(i));
        }
        return result;
    }
}

