/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.ashxml;

import de.ashampoo.ashxml.BufferedCharReader;
import de.ashampoo.ashxml.MalformedXmlException;
import de.ashampoo.ashxml.XmlNode;
import java.io.InputStream;

public class XmlParser {
    private static final String IGNORED_CHARS = "\t\n\r ";
    private static final String SPECIAL_CHARS = ".-_#";
    private BufferedCharReader reader = null;
    private XmlNode document = new XmlNode("", null);

    public XmlParser(InputStream inStream) throws MalformedXmlException {
        this.reader = new BufferedCharReader(inStream);
        this.advanceIgnoredChars();
        this.advanceComment();
        this.advanceIgnoredChars();
        this.advanceXmlHeader();
        this.advanceIgnoredChars();
        this.advanceComment();
        this.advanceIgnoredChars();
        this.document.addChild(this.parseXmlNode(this.document));
    }

    private String advanceIgnoredChars() {
        StringBuffer buffer = new StringBuffer();
        while (this.reader.hasMoreChars()) {
            char c = this.reader.peekChar();
            boolean finishLoop = true;
            for (int i = 0; i < IGNORED_CHARS.length(); ++i) {
                if (c != IGNORED_CHARS.charAt(i)) continue;
                buffer.append(c);
                finishLoop = false;
                this.reader.popChar();
                break;
            }
            if (!finishLoop) continue;
            break;
        }
        return buffer.toString();
    }

    private boolean isSpecialChar(char c) {
        for (int i = 0; i < SPECIAL_CHARS.length(); ++i) {
            if (SPECIAL_CHARS.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    private boolean isWhitespace(char c) {
        return c == ' ';
    }

    private boolean isNumeric(char c) {
        return '0' <= c && c <= '9';
    }

    private boolean isLetter(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private boolean isAlphnumeric(char c) {
        return this.isNumeric(c) || this.isLetter(c);
    }

    private void accept(char c) throws MalformedXmlException {
        char nextChar = this.reader.popChar();
        if (nextChar != c) {
            throw new MalformedXmlException("accept() unexspected char found exspected: " + c + " found: " + nextChar);
        }
    }

    private void accept(String s) throws MalformedXmlException {
        for (int i = 0; i < s.length(); ++i) {
            this.accept(s.charAt(i));
        }
    }

    private String parseKeyword() throws MalformedXmlException {
        StringBuffer buffer = new StringBuffer();
        boolean firstChar = true;
        while (this.reader.hasMoreChars()) {
            char c = this.reader.peekChar();
            if (firstChar) {
                if (!this.isLetter(c)) {
                    throw new MalformedXmlException("parseKeyword() unknown char found " + c);
                }
                buffer.append(c);
                this.reader.popChar();
                firstChar = false;
                continue;
            }
            if (this.isAlphnumeric(c) || c == '-' || c == '_') {
                buffer.append(c);
                this.reader.popChar();
                continue;
            }
            return buffer.toString();
        }
        throw new MalformedXmlException("parseKeyword() file ended before keyword parsing");
    }

    private String parseString() throws MalformedXmlException {
        this.accept('\"');
        boolean backslash = false;
        StringBuffer buffer = new StringBuffer();
        while (this.reader.hasMoreChars()) {
            char c = this.reader.popChar();
            if (this.isAlphnumeric(c) || this.isWhitespace(c) || this.isSpecialChar(c)) {
                buffer.append(c);
                continue;
            }
            if (c == '\"') break;
            throw new MalformedXmlException("parseString() unknown character in string. parsedString: \"" + buffer.toString() + "\" nextchar: " + c);
        }
        return buffer.toString();
    }

    private void advanceXmlHeader() throws MalformedXmlException {
        this.advanceIgnoredChars();
        String s = this.reader.peekString(5);
        if (s.equals("<?xml")) {
            while (this.reader.hasMoreChars() && !(s = this.reader.peekString(2)).equals("?>")) {
                this.reader.popChar();
            }
            this.accept("?>");
        }
    }

    private void advanceComment() throws MalformedXmlException {
        this.advanceIgnoredChars();
        String s = this.reader.peekString(4);
        if (s.equals("<!--")) {
            while (this.reader.hasMoreChars()) {
                s = this.reader.peekString(3);
                if (s.equals("-->")) {
                    this.accept('-');
                    this.accept('-');
                    this.accept('>');
                    break;
                }
                this.reader.popChar();
            }
        }
    }

    private String readContent() {
        char c;
        StringBuffer buffer = new StringBuffer();
        while (this.reader.hasMoreChars() && (c = this.reader.peekChar()) != '<') {
            buffer.append(c);
            this.reader.popChar();
        }
        return buffer.toString();
    }

    private XmlNode parseXmlNode(XmlNode parent) throws MalformedXmlException {
        this.advanceComment();
        this.accept('<');
        String nodeName = this.parseKeyword();
        XmlNode node = new XmlNode(nodeName, parent);
        while (this.reader.hasMoreChars()) {
            this.advanceIgnoredChars();
            if (this.reader.peekChar() == '/') {
                this.accept('/');
                this.advanceIgnoredChars();
                this.accept('>');
                return node;
            }
            if (this.reader.peekChar() == '>') {
                this.accept('>');
                String content = this.advanceIgnoredChars();
                if (this.reader.peekChar() == '<') {
                    while (true) {
                        this.advanceIgnoredChars();
                        this.advanceComment();
                        this.advanceIgnoredChars();
                        String endTag = this.reader.peekString(2);
                        if (endTag.equals("</")) {
                            this.accept('<');
                            this.accept('/');
                            this.advanceIgnoredChars();
                            String endTagName = this.parseKeyword();
                            if (!nodeName.equals(endTagName)) {
                                throw new MalformedXmlException("parseXmlNode(): starttag != endtag  startag:\"" + node.getName() + "\" endtag:\"" + endTagName + "\"");
                            }
                            this.advanceIgnoredChars();
                            this.accept('>');
                            return node;
                        }
                        XmlNode childNode = this.parseXmlNode(node);
                        node.addChild(childNode);
                    }
                }
                content = content + this.readContent();
                node.setValue(content);
                this.accept('<');
                this.accept('/');
                this.advanceIgnoredChars();
                String endTagName = this.parseKeyword();
                if (!nodeName.equals(endTagName)) {
                    throw new MalformedXmlException("parseXmlNode(): starttag != endtag  startag:\"" + node.getName() + "\" endtag:\"" + endTagName + "\"");
                }
                this.advanceIgnoredChars();
                this.accept('>');
                return node;
            }
            String attributeName = this.parseKeyword();
            this.accept('=');
            String attributeValue = this.parseString();
            node.addAttribute(attributeName, attributeValue);
        }
        return null;
    }

    public XmlNode getDocument() {
        return this.document;
    }
}

