/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.bdj.debug;

import de.ashampoo.bdj.MenuHandler;
import de.ashampoo.bdj.debug.Log;
import java.awt.Font;
import java.awt.Graphics;

public class LogOverlay {
    private Log log = Log.getInstance();
    private Font font = new Font(null, 0, 20);
    private int entriesPerPage = 1;
    private int currentPage = 1;

    public void paintOverlay(Graphics g) {
        g.setFont(this.font);
        this.entriesPerPage = MenuHandler.getInstance().getHeight() / (g.getFontMetrics().getHeight() + 10) - 2;
        int y = 50 + g.getFontMetrics().getHeight() / 2;
        int startIdx = (this.currentPage - 1) * this.entriesPerPage;
        int endIdx = Math.min(startIdx + this.entriesPerPage, this.log.getItemCount());
        for (int i = startIdx; i < endIdx; ++i) {
            String entry = this.log.getItem(i);
            g.drawString(entry, 50, y);
            y += g.getFontMetrics().getHeight() + 10;
        }
        String count = "page (" + this.currentPage + "/" + this.getPageCount() + ")";
        g.drawString(count, MenuHandler.getInstance().getWidth() - 400, y);
    }

    public void paintLastLinesOverlay(Graphics g) {
        g.setFont(this.font);
        this.entriesPerPage = MenuHandler.getInstance().getHeight() / (g.getFontMetrics().getHeight() + 10) - 2;
        int y = 50 + g.getFontMetrics().getHeight() / 2;
        for (int i = this.log.getItemCount() - 1; i > this.log.getItemCount() - 15; --i) {
            String entry = this.log.getItem(i);
            g.drawString(entry, 50, y);
            y += g.getFontMetrics().getHeight() + 10;
        }
    }

    public int getPageCount() {
        return this.log.getItemCount() / this.entriesPerPage + 1;
    }

    public void nextPage() {
        ++this.currentPage;
        if (this.currentPage >= this.getPageCount()) {
            this.currentPage = this.getPageCount();
        }
    }

    public void prevPage() {
        --this.currentPage;
        if (this.currentPage < 1) {
            this.currentPage = 1;
        }
    }
}

