/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.bdj.gui;

import de.ashampoo.bdj.debug.Log;
import de.ashampoo.bdj.gui.ImageAnimation;
import java.util.Vector;

public class Animator {
    private static Animator instance = null;
    private Vector animations = new Vector();
    private Thread animatorThread = new Thread(){

        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Animator.this.animate();
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException ex) {
            }
            catch (Exception e) {
                Log.getInstance().logException(this.getClass(), e);
            }
        }
    };

    public static synchronized Animator getInstance() {
        if (instance == null) {
            instance = new Animator();
        }
        return instance;
    }

    private Animator() {
        this.animatorThread.setPriority(1);
        this.animatorThread.start();
    }

    public void destroy() {
        this.animatorThread.interrupt();
    }

    public synchronized void registerAnimation(ImageAnimation animation) {
        this.animations.add(animation);
    }

    private synchronized void animate() {
        for (int i = 0; i < this.animations.size(); ++i) {
            ((ImageAnimation)this.animations.get(i)).nextImage();
        }
    }
}

