/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.bdj.gui;

import de.ashampoo.bdj.gui.Component;
import de.ashampoo.bdj.gui.Point;
import de.ashampoo.bdj.gui.Rectangle;
import java.awt.Graphics2D;
import java.util.Vector;

public class Container
implements Component {
    private Component parent = null;
    private Vector components = new Vector();
    private Point position = null;

    public Container(Component parent, Point position) {
        this.parent = parent;
        this.position = position;
    }

    public Rectangle getRect() {
        Rectangle rect = null;
        for (int i = 0; i < this.size(); ++i) {
            rect = rect != null ? rect.createUnion(this.get(i).getRect()) : this.get(i).getRect();
        }
        return rect;
    }

    public Component getParent() {
        return this.parent;
    }

    public void add(Component r) {
        this.components.add(r);
    }

    public int size() {
        return this.components.size();
    }

    public Component get(int index) {
        return (Component)this.components.get(index);
    }

    public void draw(Graphics2D g, Point pt) {
        Point newPt = new Point(pt.x + this.position.x, pt.y + this.position.y);
        for (int i = 0; i < this.size(); ++i) {
            Component comp = (Component)this.components.get(i);
            comp.draw(g, newPt);
        }
    }

    public void invalidate() {
        this.parent.invalidateRect(this.getRect());
    }

    public void invalidateRect(Rectangle rect) {
        this.parent.invalidateRect(new Rectangle(rect.x + this.position.x, rect.y + this.position.y, rect.width, rect.height));
    }
}

