/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.bdj.gui;

import de.ashampoo.bdj.ButtonActionListener;
import de.ashampoo.bdj.gui.GuiPainter;
import de.ashampoo.bdj.gui.RootContainer;
import de.ashampoo.bdj.util.AshPlayer;
import org.dvb.event.EventManager;
import org.dvb.event.UserEvent;
import org.dvb.event.UserEventListener;
import org.dvb.event.UserEventRepository;

public class KeyManager
implements UserEventListener {
    private int debugKeyIndex = 0;
    private int[] debugKeys = new int[]{49, 54, 48, 50};
    private GuiPainter gui = null;
    private RootContainer container = null;
    private ButtonActionListener buttonActionListener;

    public KeyManager(GuiPainter gui, RootContainer container, ButtonActionListener listener) {
        this.gui = gui;
        this.container = container;
        this.buttonActionListener = listener;
        UserEventRepository userEventRepo = new UserEventRepository("evt");
        userEventRepo.addAllNumericKeys();
        userEventRepo.addAllArrowKeys();
        userEventRepo.addKey(461);
        userEventRepo.addKey(10);
        userEventRepo.addKey(425);
        userEventRepo.addKey(424);
        EventManager.getInstance().addUserEventListener((UserEventListener)this, userEventRepo);
    }

    public void destroy() {
        EventManager.getInstance().removeUserEventListener((UserEventListener)this);
    }

    public void setContainer(RootContainer container) {
        this.container = container;
    }

    public void userEventReceived(UserEvent ue) {
        this.gui.doFullRepaint();
        if (ue.getType() == 401) {
            if (this.gui.isDebugEnabled()) {
                this.handleDebugKeys(ue);
            } else if (this.debugKeys[this.debugKeyIndex] == ue.getCode()) {
                ++this.debugKeyIndex;
                if (this.debugKeys.length == this.debugKeyIndex) {
                    this.debugKeyIndex = 0;
                    this.gui.setDebugEnabled(true);
                }
            } else {
                this.debugKeyIndex = 0;
                if (AshPlayer.getInstance().isPlaying()) {
                    this.handleEventWhilePlaying(ue);
                } else {
                    this.handleMenuEvent(ue);
                }
            }
            if (this.gui.isDebugEnabled()) {
                this.gui.doFullRepaint();
            } else {
                this.gui.repaint();
            }
        }
    }

    private void handleEventWhilePlaying(UserEvent ue) {
        switch (ue.getCode()) {
            case 461: {
                this.buttonActionListener.onResume(false);
            }
        }
    }

    private void handleMenuEvent(UserEvent ue) {
        switch (ue.getCode()) {
            case 37: {
                this.container.moveLeft();
                break;
            }
            case 39: {
                this.container.moveRight();
                break;
            }
            case 38: {
                this.container.moveUp();
                break;
            }
            case 40: {
                this.container.moveDown();
                break;
            }
            case 10: {
                this.container.selectHighlighted();
            }
        }
    }

    private void handleDebugKeys(UserEvent ue) {
        switch (ue.getCode()) {
            case 37: {
                this.gui.getOverlay().prevPage();
                break;
            }
            case 39: {
                this.gui.getOverlay().nextPage();
                break;
            }
            case 10: 
            case 57: {
                this.gui.setDebugEnabled(false);
                this.gui.doFullRepaint();
            }
        }
    }
}

