/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.bdj.gui;

import de.ashampoo.bdj.debug.Log;
import de.ashampoo.bdj.gui.Button;
import de.ashampoo.bdj.gui.Component;
import de.ashampoo.bdj.gui.Container;
import de.ashampoo.bdj.gui.DirtyRectListener;
import de.ashampoo.bdj.gui.HighlightComponent;
import de.ashampoo.bdj.gui.Point;
import de.ashampoo.bdj.gui.Rectangle;
import java.awt.Graphics2D;
import java.util.Vector;

public class RootContainer
extends Container {
    private HighlightComponent selectedComponent = null;
    private Vector selectableItems = new Vector();
    private DirtyRectListener dirtyRectListener = null;

    public RootContainer() {
        super(null, new Point(0, 0));
    }

    public void invalidate() {
        if (this.dirtyRectListener != null) {
            this.dirtyRectListener.invalidateAll();
        }
    }

    public void invalidateRect(Rectangle rect) {
        if (this.dirtyRectListener != null) {
            this.dirtyRectListener.addDirtyRect(rect);
        }
    }

    public void traverseComponent(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.size(); ++i) {
                this.traverseComponent(container.get(i));
            }
        } else if (component instanceof HighlightComponent) {
            this.selectableItems.add(component);
        }
    }

    public void add(Component component) {
        super.add(component);
        this.traverseComponent(component);
        if (this.selectedComponent == null && this.selectableItems.size() > 0) {
            this.setSelected((HighlightComponent)this.selectableItems.get(0));
        }
    }

    public void draw(Graphics2D g) {
        super.draw(g, new Point(0, 0));
        if (this.selectedComponent != null) {
            this.selectedComponent.drawHighlight(g, new Point(0, 0));
        }
    }

    private void setSelected(HighlightComponent newComponent) {
        if (newComponent != null) {
            if (this.selectedComponent != null) {
                this.selectedComponent.invalidate();
            }
            this.selectedComponent = newComponent;
            this.selectedComponent.invalidate();
            Log.getInstance().log(this.getClass(), "selected button: " + ((Button)this.selectedComponent).getId());
        } else {
            Log.getInstance().log(this.getClass(), "selected button is null");
        }
    }

    public void selectHighlighted() {
        this.selectedComponent.fireSelectionEvent();
    }

    private HighlightComponent getComponentById(String id) {
        for (int i = 0; i < this.selectableItems.size(); ++i) {
            HighlightComponent comp = (HighlightComponent)this.selectableItems.get(i);
            if (!comp.getId().equals(id)) continue;
            return comp;
        }
        return null;
    }

    public void moveUp() {
        if (this.selectedComponent == null) {
            if (this.selectableItems.size() > 0) {
                this.setSelected((HighlightComponent)this.selectableItems.get(0));
            }
        } else {
            HighlightComponent component = this.getComponentById(this.selectedComponent.getUpComponent());
            if (component != null) {
                this.setSelected(component);
            }
        }
    }

    public void moveDown() {
        if (this.selectedComponent == null) {
            if (this.selectableItems.size() > 0) {
                this.setSelected((HighlightComponent)this.selectableItems.get(0));
            }
        } else {
            HighlightComponent component = this.getComponentById(this.selectedComponent.getDownComponent());
            if (component != null) {
                this.setSelected(component);
            }
        }
    }

    public void moveLeft() {
        if (this.selectedComponent == null) {
            if (this.selectableItems.size() > 0) {
                this.setSelected((HighlightComponent)this.selectableItems.get(0));
            }
        } else {
            HighlightComponent component = this.getComponentById(this.selectedComponent.getLeftComponent());
            if (component != null) {
                this.setSelected(component);
            }
        }
    }

    public void moveRight() {
        if (this.selectedComponent == null) {
            if (this.selectableItems.size() > 0) {
                this.setSelected((HighlightComponent)this.selectableItems.get(0));
            }
        } else {
            HighlightComponent component = this.getComponentById(this.selectedComponent.getRightComponent());
            if (component != null) {
                this.setSelected(component);
            }
        }
    }

    public void setDirtyRectListener(DirtyRectListener dirtyRectListener) {
        this.dirtyRectListener = dirtyRectListener;
    }
}

