/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.bdj.util;

import de.ashampoo.ashxml.MalformedXmlException;
import de.ashampoo.ashxml.XmlNode;
import de.ashampoo.ashxml.XmlParser;
import de.ashampoo.bdj.debug.Log;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ResourceLoader {
    private static ResourceLoader instance = null;
    private String imagePath = "";
    private String xmlPath = "";
    private String anmPath = "";
    private String sndPath = "";
    private HashMap cachedImages = new HashMap();
    static /* synthetic */ Class class$de$ashampoo$bdj$util$ResourceLoader;

    public static synchronized ResourceLoader getInstance() {
        if (instance == null) {
            instance = new ResourceLoader();
        }
        return instance;
    }

    private ResourceLoader() {
        String vfsRoot = System.getProperty("bluray.vfs.root");
        if (!vfsRoot.endsWith(File.separator)) {
            vfsRoot = vfsRoot + File.separator;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(vfsRoot);
        buffer.append("BDMV");
        buffer.append(File.separator);
        buffer.append("JAR");
        buffer.append(File.separator);
        buffer.append("res");
        buffer.append(File.separator);
        String resourceDir = buffer.toString();
        this.imagePath = resourceDir + "img" + File.separator;
        this.anmPath = resourceDir + "anm" + File.separator;
        this.sndPath = resourceDir;
        this.xmlPath = resourceDir;
        Log.getInstance().log(class$de$ashampoo$bdj$util$ResourceLoader == null ? (class$de$ashampoo$bdj$util$ResourceLoader = ResourceLoader.class$("de.ashampoo.bdj.util.ResourceLoader")) : class$de$ashampoo$bdj$util$ResourceLoader, "imagePath: " + this.imagePath);
        Log.getInstance().log(class$de$ashampoo$bdj$util$ResourceLoader == null ? (class$de$ashampoo$bdj$util$ResourceLoader = ResourceLoader.class$("de.ashampoo.bdj.util.ResourceLoader")) : class$de$ashampoo$bdj$util$ResourceLoader, "xmlPath: " + this.xmlPath);
    }

    private XmlNode parseXml(InputStream xml) throws MalformedXmlException {
        XmlParser parser = new XmlParser(xml);
        XmlNode node = parser.getDocument();
        if (node == null) {
            Log.getInstance().log(this.getClass(), "XML error. no root node found in document");
        }
        return node;
    }

    public String getSoundFile(String name) {
        return this.sndPath + name;
    }

    public XmlNode loadXml(String name) {
        Log.getInstance().log(this.getClass(), "trying to load xml: " + name);
        try {
            String path = this.xmlPath + name;
            File file = new File(path);
            if (!file.exists()) {
                throw new FileNotFoundException(path);
            }
            XmlNode node = this.parseXml(new FileInputStream(file));
            if (node != null) {
                Log.getInstance().log(this.getClass(), "load successful");
            } else {
                Log.getInstance().log(this.getClass(), "load failed");
            }
            return node;
        }
        catch (Exception e) {
            Log.getInstance().logException(this.getClass(), e);
            return null;
        }
    }

    public Image[] loadAnimation(Component comp, String name) {
        Log.getInstance().log(this.getClass(), "trying to load animation: " + name);
        try {
            String path = this.anmPath + name;
            File file = new File(path);
            if (!file.exists()) {
                throw new FileNotFoundException(path);
            }
            ZipFile jarFile = new ZipFile(file, 1);
            Enumeration<? extends ZipEntry> enumerate = jarFile.entries();
            MediaTracker tracker = new MediaTracker(comp);
            int currentId = 1000;
            int counter = 0;
            Vector<Image> images = new Vector<Image>();
            while (enumerate.hasMoreElements()) {
                ZipEntry entry = enumerate.nextElement();
                InputStream imageInputStream = jarFile.getInputStream(entry);
                byte[] imageData = new byte[(int)entry.getSize()];
                int readen = 0;
                while ((long)readen < entry.getSize()) {
                    readen += imageInputStream.read(imageData, readen, (int)(entry.getSize() - (long)readen));
                }
                Image img = Toolkit.getDefaultToolkit().createImage(imageData);
                images.add(img);
                tracker.addImage(img, currentId + counter);
                ++counter;
            }
            tracker.waitForAll();
            if (tracker.isErrorAny()) {
                Log.getInstance().log(this.getClass(), "error loading animation: " + path);
            }
            Image[] result = new Image[images.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (Image)images.get(i);
            }
            return result;
        }
        catch (Exception e) {
            Log.getInstance().logException(this.getClass(), e);
            return null;
        }
    }

    public Image loadImage(Component comp, String name) {
        if (this.cachedImages.containsKey(name)) {
            return (Image)this.cachedImages.get(name);
        }
        try {
            String path = this.imagePath + name;
            Log.getInstance().log(this.getClass(), "loading image: " + path);
            if (!new File(path).exists()) {
                throw new FileNotFoundException(path);
            }
            MediaTracker tracker = new MediaTracker(comp);
            Image img = Toolkit.getDefaultToolkit().createImage(path);
            tracker.addImage(img, 100);
            tracker.waitForID(100);
            if (tracker.isErrorID(100)) {
                Log.getInstance().log(this.getClass(), "error loading image: " + path);
                return null;
            }
            this.cachedImages.put(name, img);
            return img;
        }
        catch (Exception e) {
            Log.getInstance().logException(this.getClass(), e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

