/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.discmenu;

import de.ashampoo.ashxml.XmlNode;
import de.ashampoo.discmenu.ActionType;
import de.ashampoo.discmenu.DiscMenuException;
import de.ashampoo.discmenu.DiscMenuInterface;

public class Action
implements DiscMenuInterface {
    private ActionType type = null;
    private int infileId = 0;
    private String target = "";
    private int chapter = 0;

    public String toString() {
        return "Action: [type=" + this.type.toString() + ", infileId=" + this.infileId + ", target=" + this.target + "]";
    }

    public void loadFromXml(XmlNode node) throws DiscMenuException {
        this.type = ActionType.getActionType(node.getAttribute("type"));
        if (this.type == null) {
            throw new DiscMenuException("unknown type '" + node.getAttribute("type") + "' for action");
        }
        if (this.type == ActionType.play) {
            this.infileId = node.getIntAttribute("infile-id");
            this.chapter = node.getIntAttribute("chapter");
        } else if (this.type != ActionType.back && this.type != ActionType.playall) {
            this.target = node.getAttribute("target");
            if (this.target.equals("")) {
                throw new DiscMenuException("no target was set for action");
            }
        }
    }

    public int getInfileId() {
        return this.infileId;
    }

    public String getTarget() {
        return this.target;
    }

    public ActionType getType() {
        return this.type;
    }

    public int getChapter() {
        return this.chapter;
    }
}

