require 'sketchup.rb'


def cos_hip(x)

  return (Math::exp(x) + Math::exp(-x))/2

end


def superellipse_superellipsoid

  prompt = ["# Iterations : ", "x Scale Factor : ", "y Scale Factor : ", "z Scale Factor : ", "z Squareness : ", "x-y Squareness : "]
  params = [5, 1.0, 1.0, 1.0, 1.0, 3.0]
  result = inputbox(prompt, params, "Imput Superellipse/Superellipsoid Parameters")
  if result
    it = [2, result[0]].max
    rx = [1.0, result[1].abs].max
    ry = [1.0, result[2].abs].max
    rz = [1.0, result[3].abs].max
    n1 = [0.05, result[4].abs].max
    n2 = [0.05, result[5].abs].max
  else
    return
  end

  entities = Sketchup.active_model.entities
  group = entities.add_group
  group_ents = group.entities

  mesh_ss1 = Geom::PolygonMesh.new
  mesh_ss2 = Geom::PolygonMesh.new
  mesh_ss3 = Geom::PolygonMesh.new
  mesh_ss4 = Geom::PolygonMesh.new
  mesh_ss5 = Geom::PolygonMesh.new
  mesh_ss6 = Geom::PolygonMesh.new
  mesh_ss7 = Geom::PolygonMesh.new
  mesh_ss8 = Geom::PolygonMesh.new
  indexes = [0]
  aux_vect = []

  for ind_u in (0..2*it)
    u = (Math::PI/2)*ind_u/(2*it)
    for ind_v in (0..2*it)
      v = (Math::PI/2)*ind_v/(2*it)
      x = rx*(Math::cos(u)**n1)*(Math::cos(v)**n2)
      y = ry*(Math::cos(u)**n1)*(Math::sin(v)**n2)
      z = rz*(Math::sin(u)**n1)
      pt = Geom::Point3d.new(100*x, 100*y, 100*z)
      index = mesh_ss1.add_point(pt)
      pt = Geom::Point3d.new(-100*x, -100*y, 100*z)
      index = mesh_ss2.add_point(pt)
      pt = Geom::Point3d.new(-100*x, 100*y, -100*z)
      index = mesh_ss3.add_point(pt)
      pt = Geom::Point3d.new(100*x, -100*y, -100*z)
      index = mesh_ss4.add_point(pt)
      pt = Geom::Point3d.new(100*x, 100*y, -100*z)
      index = mesh_ss5.add_point(pt)
      pt = Geom::Point3d.new(-100*x, -100*y, -100*z)
      index = mesh_ss6.add_point(pt)
      pt = Geom::Point3d.new(-100*x, 100*y, 100*z)
      index = mesh_ss7.add_point(pt)
      pt = Geom::Point3d.new(100*x, -100*y, 100*z)
      index = mesh_ss8.add_point(pt)
      indexes.push(index)
    end
  end

  for ind_u in (1..2*it)
    for ind_v in (1..2*it)
      aux_ind = (2*it+1)*(ind_u-1) + ind_v
      aux_vect = [indexes[aux_ind], indexes[aux_ind+1], indexes[aux_ind+1+2*it]]
      mesh_ss1.add_polygon(aux_vect)
      mesh_ss2.add_polygon(aux_vect)
      mesh_ss3.add_polygon(aux_vect)
      mesh_ss4.add_polygon(aux_vect)
      aux_vect = [indexes[aux_ind], indexes[aux_ind+1+2*it], indexes[aux_ind+1]]
      mesh_ss5.add_polygon(aux_vect)
      mesh_ss6.add_polygon(aux_vect)
      mesh_ss7.add_polygon(aux_vect)
      mesh_ss8.add_polygon(aux_vect)
      aux_vect = [indexes[aux_ind+1], indexes[aux_ind+2+2*it], indexes[aux_ind+1+2*it]]
      mesh_ss1.add_polygon(aux_vect)
      mesh_ss2.add_polygon(aux_vect)
      mesh_ss3.add_polygon(aux_vect)
      mesh_ss4.add_polygon(aux_vect)
      aux_vect = [indexes[aux_ind+1], indexes[aux_ind+1+2*it], indexes[aux_ind+2+2*it]]
      mesh_ss5.add_polygon(aux_vect)
      mesh_ss6.add_polygon(aux_vect)
      mesh_ss7.add_polygon(aux_vect)
      mesh_ss8.add_polygon(aux_vect)
    end
  end

  group_ents.add_faces_from_mesh(mesh_ss1)
  group_ents.add_faces_from_mesh(mesh_ss2)
  group_ents.add_faces_from_mesh(mesh_ss3)
  group_ents.add_faces_from_mesh(mesh_ss4)
  group_ents.add_faces_from_mesh(mesh_ss5)
  group_ents.add_faces_from_mesh(mesh_ss6)
  group_ents.add_faces_from_mesh(mesh_ss7)
  group_ents.add_faces_from_mesh(mesh_ss8)

end


def tear_drop

  prompt = ["# Iterations : "]
  params = [5]
  result = inputbox(prompt, params, "Imput Tear Drop Parameters")
  if result
    it = [2, result[0]].max
  else
    return
  end

  entities = Sketchup.active_model.entities
  group = entities.add_group
  group_ents = group.entities

  mesh_td = Geom::PolygonMesh.new
  indexes = [0]
  aux_vect = []

  for ind_u in (0..2*it)
    u = Math::PI*ind_u/(2*it)
    for ind_v in (0..2*it-1)
      v = 2*Math::PI*ind_v/(2*it)
      x = 0.5*(1 - Math::cos(u))*Math::sin(u)*Math::cos(v)
      y = 0.5*(1 - Math::cos(u))*Math::sin(u)*Math::sin(v)
      z = Math::cos(u)
      pt = Geom::Point3d.new(100*x, 100*y, 100*z)
      index = mesh_td.add_point(pt)
      indexes.push(index)
    end
  end

  for ind_u in (1..2*it)
    for ind_v in (1..2*it-1)
      aux_ind = 2*it*(ind_u-1) + ind_v
      aux_vect = [indexes[aux_ind], indexes[aux_ind+2*it], indexes[aux_ind+1]]
      mesh_td.add_polygon(aux_vect)
      aux_vect = [indexes[aux_ind+1], indexes[aux_ind+2*it], indexes[aux_ind+1+2*it]]
      mesh_td.add_polygon(aux_vect)
    end
    aux_vect = [indexes[aux_ind+1], indexes[aux_ind+1+2*it], indexes[aux_ind+2-2*it]]
    mesh_td.add_polygon(aux_vect)
    aux_vect = [indexes[aux_ind+2-2*it], indexes[aux_ind+1+2*it], indexes[aux_ind+2]]
    mesh_td.add_polygon(aux_vect)
  end

  group_ents.add_faces_from_mesh(mesh_td)

end


def horn_shape

  prompt = ["# Iterations : "]
  params = [5]
  result = inputbox(prompt, params, "Imput Horn Shape Parameters")
  if result
    it = [2, result[0]].max
  else
    return
  end

  entities = Sketchup.active_model.entities
  group = entities.add_group
  group_ents = group.entities

  mesh_hs = Geom::PolygonMesh.new
  indexes = [0]
  aux_vect = []

  for ind_u in (0..2*it)
    u = ind_u/(2.0*it)
    for ind_v in (0..2*it-1)
      v = 2*Math::PI*ind_v/(2*it)
      x = (2 + u*Math::cos(v))*Math::sin(2*Math::PI*u)
      y = (2 + u*Math::cos(v))*Math::cos(2*Math::PI*u) + 2*u
      z = u*Math::sin(v)
      pt = Geom::Point3d.new(100*x, 100*y, 100*z)
      index = mesh_hs.add_point(pt)
      indexes.push(index)
    end
  end

  for ind_u in (1..2*it)
    for ind_v in (1..2*it-1)
      aux_ind = 2*it*(ind_u-1) + ind_v
      aux_vect = [indexes[aux_ind], indexes[aux_ind+1], indexes[aux_ind+2*it]]
      mesh_hs.add_polygon(aux_vect)
      aux_vect = [indexes[aux_ind+1], indexes[aux_ind+1+2*it], indexes[aux_ind+2*it]]
      mesh_hs.add_polygon(aux_vect)
    end
    aux_vect = [indexes[aux_ind+1], indexes[aux_ind+2-2*it], indexes[aux_ind+1+2*it]]
    mesh_hs.add_polygon(aux_vect)
    aux_vect = [indexes[aux_ind+2-2*it], indexes[aux_ind+2], indexes[aux_ind+1+2*it]]
    mesh_hs.add_polygon(aux_vect)
  end

  group_ents.add_faces_from_mesh(mesh_hs)

end


def misc_torus

  prompt = ["# Iterations : ", "c Value : "]
  params = [5, 1.5]
  result = inputbox(prompt, params, "Imput Misc Torus Parameters")
  if result
    it = [2, result[0]].max
    c = result[1].abs
  else
    return
  end

  entities = Sketchup.active_model.entities
  group = entities.add_group
  group_ents = group.entities

  mesh_mt = Geom::PolygonMesh.new
  indexes = [0]
  aux_vect = []

  for ind_u in (-it..it-1)
    u = Math::PI*ind_u/it
    for ind_v in (-it..it-1)
      v = Math::PI*ind_v/it
      x = Math::cos(u)*(c + Math::sin(v)*Math::cos(u) - Math::sin(2*v)*Math::sin(u)/2)
      y = Math::sin(u)*(c + Math::sin(v)*Math::cos(u) - Math::sin(2*v)*Math::sin(u)/2)
      z = Math::sin(u)*Math::sin(v) + Math::cos(u)*Math::sin(2*v)/2
      pt = Geom::Point3d.new(100*x, 100*y, 100*z)
      index = mesh_mt.add_point(pt)
      indexes.push(index)
    end
  end

  for ind_u in (1..2*it-1)
    for ind_v in (1..2*it-1)
      aux_ind = 2*it*(ind_u-1) + ind_v
      aux_vect = [indexes[aux_ind], indexes[aux_ind+2*it], indexes[aux_ind+1]]
      mesh_mt.add_polygon(aux_vect)
      aux_vect = [indexes[aux_ind+1], indexes[aux_ind+2*it], indexes[aux_ind+1+2*it]]
      mesh_mt.add_polygon(aux_vect)
    end
    aux_vect = [indexes[aux_ind+1], indexes[aux_ind+1+2*it], indexes[aux_ind+2-2*it]]
    mesh_mt.add_polygon(aux_vect)
    aux_vect = [indexes[aux_ind+2-2*it], indexes[aux_ind+1+2*it], indexes[aux_ind+2]]
    mesh_mt.add_polygon(aux_vect)
  end
  for ind_v in (1..2*it-1)
    aux_vect = [indexes[ind_v], indexes[ind_v+1], indexes[2*it*(2*it-1)+ind_v+1]]
    mesh_mt.add_polygon(aux_vect)
    aux_vect = [indexes[ind_v], indexes[2*it*(2*it-1)+ind_v+1], indexes[2*it*(2*it-1)+ind_v]]
    mesh_mt.add_polygon(aux_vect)
  end
  aux_vect = [indexes[2*it*(2*it-1)+1], indexes[4*it*it], indexes[2*it]]
  mesh_mt.add_polygon(aux_vect)
  aux_vect = [indexes[1], indexes[2*it*(2*it-1)+1], indexes[2*it]]
  mesh_mt.add_polygon(aux_vect)

  group_ents.add_faces_from_mesh(mesh_mt)

end


def jet_surface

  prompt = ["# Iterations : "]
  params = [5]
  result = inputbox(prompt, params, "Imput Jet Surface Parameters")
  if result
    it = [2, result[0]].max
  else
    return
  end

  entities = Sketchup.active_model.entities
  group = entities.add_group
  group_ents = group.entities

  mesh_js = Geom::PolygonMesh.new
  indexes = [0]
  aux_vect = []

  for ind_u in (0..2*it)
    u = Math::PI*ind_u/(2*it)
    for ind_v in (0..2*it-1)
      v = 2*Math::PI*ind_v/(2*it)
      x = (1 - cos_hip(u))*Math::sin(u)*Math::cos(v)/2
      y = (1 - cos_hip(u))*Math::sin(u)*Math::sin(v)/2
      z = cos_hip(u)
      pt = Geom::Point3d.new(100*x, 100*y, 100*z)
      index = mesh_js.add_point(pt)
      indexes.push(index)
    end
  end

  for ind_u in (1..2*it)
    for ind_v in (1..2*it-1)
      aux_ind = 2*it*(ind_u-1) + ind_v
      aux_vect = [indexes[aux_ind], indexes[aux_ind+1], indexes[aux_ind+2*it]]
      mesh_js.add_polygon(aux_vect)
      aux_vect = [indexes[aux_ind+1], indexes[aux_ind+1+2*it], indexes[aux_ind+2*it]]
      mesh_js.add_polygon(aux_vect)
    end
    aux_vect = [indexes[aux_ind+1], indexes[aux_ind+2-2*it], indexes[aux_ind+1+2*it]]
    mesh_js.add_polygon(aux_vect)
    aux_vect = [indexes[aux_ind+2-2*it], indexes[aux_ind+2], indexes[aux_ind+1+2*it]]
    mesh_js.add_polygon(aux_vect)
  end

  group_ents.add_faces_from_mesh(mesh_js)

end


def pisot_triaxial

  prompt = ["# Iterations : "]
  params = [5]
  result = inputbox(prompt, params, "Imput Pisot Triaxial Parameters")
  if result
    it = [2, result[0]].max
  else
    return
  end

  entities = Sketchup.active_model.entities
  group = entities.add_group
  group_ents = group.entities

  mesh_pt = Geom::PolygonMesh.new
  indexes = [0]
  aux_vect = []

  for ind_u in (0..2*it-1)
    u = 2*Math::PI*ind_u/(2*it)
    for ind_v in (0..2*it-1)
      v = 2*Math::PI*ind_v/(2*it)
      x = 0.655866*Math::cos(1.03002+u)*(2 + Math::cos(v))
      y = 0.754878*Math::cos(1.40772-u)*(2 + 0.868837*Math::cos(2.43773+v))
      z = 0.868837*Math::cos(2.43773+u)*(2 + 0.495098*Math::cos(0.377696-v))
      pt = Geom::Point3d.new(100*x, 100*y, 100*z)
      index = mesh_pt.add_point(pt)
      indexes.push(index)
    end
  end

  for ind_u in (1..2*it-1)
    for ind_v in (1..2*it-1)
      aux_ind = 2*it*(ind_u-1) + ind_v
      aux_vect = [indexes[aux_ind], indexes[aux_ind+1], indexes[aux_ind+2*it]]
      mesh_pt.add_polygon(aux_vect)
      aux_vect = [indexes[aux_ind+1], indexes[aux_ind+1+2*it], indexes[aux_ind+2*it]]
      mesh_pt.add_polygon(aux_vect)
    end
    aux_vect = [indexes[aux_ind+1], indexes[aux_ind+2-2*it], indexes[aux_ind+1+2*it]]
    mesh_pt.add_polygon(aux_vect)
    aux_vect = [indexes[aux_ind+2-2*it], indexes[aux_ind+2], indexes[aux_ind+1+2*it]]
    mesh_pt.add_polygon(aux_vect)
  end
  for ind_v in (1..2*it-1)
    aux_vect = [indexes[ind_v], indexes[2*it*(2*it-1)+ind_v+1], indexes[ind_v+1]]
    mesh_pt.add_polygon(aux_vect)
    aux_vect = [indexes[ind_v], indexes[2*it*(2*it-1)+ind_v], indexes[2*it*(2*it-1)+ind_v+1]]
    mesh_pt.add_polygon(aux_vect)
  end
  aux_vect = [indexes[2*it*(2*it-1)+1], indexes[2*it], indexes[4*it*it]]
  mesh_pt.add_polygon(aux_vect)
  aux_vect = [indexes[1], indexes[2*it], indexes[2*it*(2*it-1)+1]]
  mesh_pt.add_polygon(aux_vect)

  group_ents.add_faces_from_mesh(mesh_pt)

end


def elliptic_torus

  prompt = ["# Iterations : ", "c Value : "]
  params = [5, 1.2]
  result = inputbox(prompt, params, "Imput Elliptic Torus Parameters")
  if result
    it = [2, result[0]].max
    c = result[1].abs
  else
    return
  end

  entities = Sketchup.active_model.entities
  group = entities.add_group
  group_ents = group.entities

  mesh_et = Geom::PolygonMesh.new
  indexes = [0]
  aux_vect = []

  for ind_u in (-it..it-1)
    u = Math::PI*ind_u/it
    for ind_v in (-it..it-1)
      v = Math::PI*ind_v/it
      x = (c + Math::cos(v))*Math::cos(u)
      y = (c + Math::cos(v))*Math::sin(u)
      z = Math::sin(v) + Math::cos(v)
      pt = Geom::Point3d.new(100*x, 100*y, 100*z)
      index = mesh_et.add_point(pt)
      indexes.push(index)
    end
  end

  for ind_u in (1..2*it-1)
    for ind_v in (1..2*it-1)
      aux_ind = 2*it*(ind_u-1) + ind_v
      aux_vect = [indexes[aux_ind], indexes[aux_ind+2*it], indexes[aux_ind+1]]
      mesh_et.add_polygon(aux_vect)
      aux_vect = [indexes[aux_ind+1], indexes[aux_ind+2*it], indexes[aux_ind+1+2*it]]
      mesh_et.add_polygon(aux_vect)
    end
    aux_vect = [indexes[aux_ind+1], indexes[aux_ind+1+2*it], indexes[aux_ind+2-2*it]]
    mesh_et.add_polygon(aux_vect)
    aux_vect = [indexes[aux_ind+2-2*it], indexes[aux_ind+1+2*it], indexes[aux_ind+2]]
    mesh_et.add_polygon(aux_vect)
  end
  for ind_v in (1..2*it-1)
    aux_vect = [indexes[ind_v], indexes[ind_v+1], indexes[2*it*(2*it-1)+ind_v+1]]
    mesh_et.add_polygon(aux_vect)
    aux_vect = [indexes[ind_v], indexes[2*it*(2*it-1)+ind_v+1], indexes[2*it*(2*it-1)+ind_v]]
    mesh_et.add_polygon(aux_vect)
  end
  aux_vect = [indexes[2*it*(2*it-1)+1], indexes[4*it*it], indexes[2*it]]
  mesh_et.add_polygon(aux_vect)
  aux_vect = [indexes[1], indexes[2*it*(2*it-1)+1], indexes[2*it]]
  mesh_et.add_polygon(aux_vect)

  group_ents.add_faces_from_mesh(mesh_et)

end


def limpet_torus

  prompt = ["# Iterations : "]
  params = [5]
  result = inputbox(prompt, params, "Imput Limpet Torus Parameters")
  if result
    it = [2, result[0]].max
  else
    return
  end

  entities = Sketchup.active_model.entities
  group = entities.add_group
  group_ents = group.entities

  mesh_lt = Geom::PolygonMesh.new
  indexes = [0]
  aux_vect = []

  for ind_u in (-it..it-1)
    u = Math::PI*ind_u/it
    for ind_v in (-it..it-1)
      v = Math::PI*ind_v/it
      x = Math::cos(u)/(Math::sqrt(2) + Math::sin(v))
      y = Math::sin(u)/(Math::sqrt(2) + Math::sin(v))
      z = 1/(Math::sqrt(2) + Math::cos(v))
      pt = Geom::Point3d.new(100*x, 100*y, 100*z)
      index = mesh_lt.add_point(pt)
      indexes.push(index)
    end
  end

  for ind_u in (1..2*it-1)
    for ind_v in (1..2*it-1)
      aux_ind = 2*it*(ind_u-1) + ind_v
      aux_vect = [indexes[aux_ind], indexes[aux_ind+1], indexes[aux_ind+2*it]]
      mesh_lt.add_polygon(aux_vect)
      aux_vect = [indexes[aux_ind+1], indexes[aux_ind+1+2*it], indexes[aux_ind+2*it]]
      mesh_lt.add_polygon(aux_vect)
    end
    aux_vect = [indexes[aux_ind+1], indexes[aux_ind+2-2*it], indexes[aux_ind+1+2*it]]
    mesh_lt.add_polygon(aux_vect)
    aux_vect = [indexes[aux_ind+2-2*it], indexes[aux_ind+2], indexes[aux_ind+1+2*it]]
    mesh_lt.add_polygon(aux_vect)
  end
  for ind_v in (1..2*it-1)
    aux_vect = [indexes[ind_v], indexes[2*it*(2*it-1)+ind_v+1], indexes[ind_v+1]]
    mesh_lt.add_polygon(aux_vect)
    aux_vect = [indexes[ind_v], indexes[2*it*(2*it-1)+ind_v], indexes[2*it*(2*it-1)+ind_v+1]]
    mesh_lt.add_polygon(aux_vect)
  end
  aux_vect = [indexes[2*it*(2*it-1)+1], indexes[2*it], indexes[4*it*it]]
  mesh_lt.add_polygon(aux_vect)
  aux_vect = [indexes[1], indexes[2*it], indexes[2*it*(2*it-1)+1]]
  mesh_lt.add_polygon(aux_vect)

  group_ents.add_faces_from_mesh(mesh_lt)

end


# create entries in menu if the script is not loaded yet
#if (not file_loaded?("[CASF]FunShapes.rb"))
#  CASF_menu = UI.menu("Plugins").add_submenu("[CASF] Fun Shapes") 
#  CASF_menu.add_item("Superellipse/Superellipsoid") { superellipse_superellipsoid }
#  CASF_menu.add_item("Tear Drop") { tear_drop }      
#  CASF_menu.add_item("Horn Shape") { horn_shape }    
#  CASF_menu.add_item("Misc Torus") { misc_torus }  
#  CASF_menu.add_item("Jet Surface") { jet_surface }
#  CASF_menu.add_item("Pisot Triaxial") { pisot_triaxial }
#  CASF_menu.add_item("Elliptic Torus") { elliptic_torus }
#  CASF_menu.add_item("Limpet Torus") { limpet_torus }
#end


# load the script
file_loaded("[CASF]FunShapes.rb")
