# Copyright 2004, Rick Wilson 
#
# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.
#
# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
# Name :          offset.rb 1.0
# Description :   Offset edges of a selected face (new method for class Sketchup::Face)
# Author :        Rick Wilson
# Usage :         1.	Intended for developers as a method to call from 
#				within a script.  Add a "require 'offset.rb' line
#				right after the "require 'sketchup.rb' line, or cut 
#                 	and paste into the script (better, since not everyone
#				will download this).
# Date :          7.Sept.2004
# Type :          Method
# History:
#			1.0 (7.Sept.2004) - first version
# 

class Sketchup::Face
	def offset(dist)
		pi=Math::PI
		if (not ((dist.class==Fixnum || dist.class==Float || dist.class==Length) && dist!=0))
			return nil
		end
		verts=self.outer_loop.vertices
		pts=[]
		0.upto(verts.length-1) do |a|
			vec1=(verts[a].position-verts[a-(verts.length-1)].position).normalize
			vec2=(verts[a].position-verts[a-1].position).normalize
			vec3=(vec1+vec2).normalize
			if vec3.valid?
				ang=vec1.angle_between(vec2)/2
				ang=pi/2 if vec1.parallel?(vec2)
				vec3.length=dist/Math::sin(ang)
				t=Geom::Transformation.new(vec3)
				if pts.length > 0
					if not (vec2.parallel?(pts.last.vector_to(verts[a].position.transform(t))))
						t=Geom::Transformation.new(vec3.reverse)
					end
				end
				pts.push(verts[a].position.transform(t))
			end
		end
		Sketchup.active_model.active_entities.add_face(pts)
	end
end
