# Copyright 2004, Rick Wilson 

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

# Name :          instances.rb 1.0
# Description :   Select all instances of a selected component.
# Author :        Rick Wilson
# Usage :         1. Install into the plugins directory or into the 
#                    plugins/examples directory and manually load from
#			   the ruby console "load 'examples/instances.rb'" 
#                 2. Choose "Select all instances" from the context menu.
# Date :          07.Aug.2004
# Type :          Tool
# History:
#			1.0 (07.Aug.2004) - first version
# 
require 'sketchup.rb'

class Instances

	# VALIDATE SELECTION - ALLOW ONLY COMPONENTS
	def Instances::validate_selection
		s = Sketchup.active_model.selection
		return nil if ((s.empty?) || (s.length > 1))
		return true if (s.first.class == Sketchup::ComponentInstance)
	end

	# SELECT ALL INSTANCES OF SELECTED COMPONENT
	def Instances::select_all
		model=Sketchup.active_model
		ss=model.selection.first
		cName=ss.definition.name
		model.selection.add(ss.definition.instances)
	end

end		#END CLASS

if( not file_loaded?("instances.rb") )
   UI.add_context_menu_handler do |menu|
      menu.add_separator if (Instances.validate_selection)
      menu.add_item("ѡй") { Instances.select_all } if Instances.validate_selection
   end
end

#-----------------------------------------------------------------------------
file_loaded("instances.rb")
