require 'sketchup.rb'

##  VERSION 1.0

def erase_coplanar_edges
  ss = Sketchup.active_model.selection
  trunk = Array.new
  for e in ss
    if (e.kind_of?(Sketchup::Edge) && e.faces.length==2) 
      if (e.faces[0].material == e.faces[1].material && e.faces[0].normal == e.faces[1].normal)
        trunk.push(e)
      end
    end
  end
  for e in trunk
    e.erase!
  end
end

if( not file_loaded?("CLEANUP.rb") )
  UI.add_context_menu_handler do |menu|
  menu.add_item("ɾ  ") { erase_coplanar_edges }
  end
end

file_loaded "CLEANUP.rb"

    
  