# Name :          Desel 1.o
# Description :   select only edges/faces and add/remove faces from a selection
# Author :        TBD
# Web:            http://su.plugins.ro
# Usage :         make selection, use Plugins|[TBD] Desel options
# Date :          13.Aug.2oo4
# Type :          select tool
# History:        1.0 (13.Aug.2oo4) - first version

def desel_func what
   Sketchup.active_model.start_operation "Desel"

   ss = Sketchup.active_model.selection
   to_remove = []
   0.upto(ss.length) do |counter|
      to_remove.push(ss[counter]) if(ss[counter].class == what)
   end
   to_remove.each {|e| ss.remove(e)}

   Sketchup.active_model.commit_operation
end

def add_faces
   Sketchup.active_model.start_operation "Desel | Add faces"

   ss = Sketchup.active_model.selection
   0.upto(ss.length) do |counter|
      ss[counter].find_faces if(ss[counter].class == Sketchup::Edge)
   end

   Sketchup.active_model.commit_operation
end

def remove_faces
   Sketchup.active_model.start_operation "Desel | Remove faces"

   ss = Sketchup.active_model.selection
   0.upto(ss.length) do |counter|
      ss[counter].erase! if(ss[counter].class == Sketchup::Face)
   end

   Sketchup.active_model.commit_operation
end

#----------------------------------------------------------------------------
# add menu items
if( not $desel_menu_loaded )
   UI.add_context_menu_handler do |menu|
        menu.add_separator 
        tBD_menu = menu.add_submenu("༭ѡ")
        tBD_menu.add_item("ѡ ") { desel_func Sketchup::Edge}
        tBD_menu.add_item("ѡ") { desel_func Sketchup::Face}
        tBD_menu.add_item("  ") { add_faces }
        tBD_menu.add_item("Ƴ   ") { remove_faces }
	end
end

$desel_menu_loaded = true
