# Copyright 2004, Rick Wilson modified by Didier Bur

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------
# Name        :   dispatch_objects
# Description :   A script to isolate objects on separate layers
# Menu Item   :   Plugins->Dispatch objects
# Usage       :   Select "Dispatch objects" from the Plugins menu.
#             :   All items will be placed on respective layers. 
# Date        :   10/14/2004
# Type        :   tool
#-----------------------------------------------------------------------------

require 'sketchup.rb'

def dispatch_objects
  model=Sketchup.active_model
  ents=model.active_entities
  
  model.start_operation "Dispatch objects"
  
  inputbox1 = %w[Yes No].join("|")
  inputbox2 = %w[Yes No].join("|")
  inputbox3 = %w[Yes No].join("|")
  inputbox4 = %w[Yes No].join("|")
  dropdowns = [inputbox1, inputbox2, inputbox3, inputbox4]
  
  # sets the default settings
  $texts = "Yes" if not $texts
  $dims = "Yes" if not $dims
  $sect = "Yes" if not $sect
  $cons = "Yes" if not $cons

  prompts = ["Texts","Dims","Section Planes","Construction lines and points  "]
  values = [$texts, $dims, $sect, $cons]
  $texts, $dims, $sect, $cons = inputbox prompts,values, dropdowns, "Select objects types"
  #results = inputbox prompts, values, "Select objects types"
  #return if not results
  
  countText=countTextMoved=0
  countDim=countDimMoved=0
  countSect=countSectMoved=0
  countCons=countConsMoved=0
  
  if( $texts == "Yes" )
    txtLayer=model.layers.add("Texts").name
    for e in ents
      if e.class==Sketchup::Text
        countText+=1
        #puts e.layer.name
        if e.layer.name != txtLayer
          e.layer=txtLayer
          countTextMoved+=1
	end
      end
    end
  end
  
  if( $dims == "Yes" )
    dimLayer=model.layers.add("Dims").name
    for e in ents
      #if( e.class==Sketchup::DimensionLinear ) or ( e.class==Sketchup::DimensionRadial )
      if( e.typename == "DimensionLinear" ) or ( e.typename == "DimensionRadial" )
        countDim+=1
        #puts e.layer.name
        if e.layer.name != dimLayer
          e.layer=dimLayer
          countDimMoved+=1
	end
      end
    end
  end

  if( $sect == "Yes" )
    sectLayer=model.layers.add("Section Planes").name
    for e in ents
      if e.typename == "SectionPlane"
        countSect+=1
        #puts e.layer.name
        if e.layer.name != sectLayer
          e.layer=sectLayer
          countSectMoved+=1
	end
      end
    end
  end
  
  if( $cons == "Yes" )
    consLayer=model.layers.add("Construction Geometry").name
    for e in ents
      if( e.typename == "ConstructionLine" ) or ( e.typename == "ConstructionPoint" )
        countCons+=1
        #puts e.layer.name
        if e.layer.name != consLayer
          e.layer=consLayer
          countConsMoved+=1
	end
      end
    end
  end
  
  UI.messagebox( countText.to_s + " texts items found, " + countTextMoved.to_s + " moved to layer \"Text\".\n" + countDim.to_s + " dims items found, " + countDimMoved.to_s + " moved to layer \"Dims\".\n" + countSect.to_s + " sections planes items found, " + countSectMoved.to_s + " moved to layer \"Section Planes\".\n" + countCons.to_s + " construction items found, " + countConsMoved.to_s + " moved to layer \"Construction Geometry\"." )
  
  model.commit_operation

end

#if( not file_loaded?("dispatch_objects.rb") )
#    add_separator_to_menu("Plugins")
#    UI.menu("Plugins").add_item("Dispatch Objects") { dispatch_objects }
#end
#-----------------------------------------------------------------------------
file_loaded("dispatch_objects.rb")