# Copyright 2004, Jim Patrick

#   VERSION 1.0

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies, and modified copies that work 
# are posted to the SketchUp?Forum.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
# THIS SCRIPT IS A HACK ON SOMEONE ELSE'S SCRIPT, PLEASE READ CAREFULLY
# *************NO WARRANTY MEANS NO WARRANTY******************
# -----------------------------------------------------------------------------

require 'sketchup.rb'

# -----------------------------------------------------------------------------

 def create_grid
    # No error-checking at this point.  
    # A 100' X 100' grid can have a 9'-1 1/16" interval!
    
    # Prompts and default values.
    prompts = ["Width", "Length", "Interval"]
    
    # Metric uses will want to change these defaults.
    values = [500.mm, 500.mm, 10.mm]

    results = inputbox prompts, values, "Grid Size"
    width, length, interval = results

# -----------------------------------------------------------------------------

    # Start entity creation.
    model = Sketchup.active_model
    model.start_operation "Create Grid"

    entities = model.active_entities
# -----------------------------------------------------------------------------
    group = entities.add_group
    entities = group.entities
    
    # initialize step (stepped interval) , which will increment by the Interval
    step = []
    step[0] = 0
    step[1] = 0
    
    # Initialize the endpoints of the lines
    pts = []                    
    pts[0] = [0, step[0], 0]
    pts[1] = [width, 0, 0]
    pts[2] = [0, step[0], 0]
    pts[3] = [0, length, 0]
    
    # Start drawing the clines.
    # Note - these lines are made dotted 'cause I like 'em that way
    # To get different linetypes, replace all "." with other stipples.
    # Stipple choice is dashed "-", long dash "_", dashdot "-.-"
    # The quotation marks MUST be included
    
    while length >= (step[0] + interval)
    	line1 = entities.add_cline(pts[0], pts[1], "." )
    	step[0] = step[0] + interval
    	pts[0] = [0, step[0], 0]
    	pts[1] = [width, step[0], 0]
     end
        # Add one more construction line to finish the rectangle
        line1 = entities.add_cline(pts[0], pts[1], "." )

    while 
        width >= (step[1] + interval)
    	line2 = entities.add_cline(pts[2], pts[3], "." )
    	step[1] = step[1] + interval
    	pts[2] = [step[1], 0, 0]
    	pts[3] = [step[1], length, 0]
     end
        # Add one more construction line to finish the rectangle
    	line2 = entities.add_cline(pts[2], pts[3], "." )

# Close/commit group
    model.commit_operation
end

# -----------------------------------------------------------------------------


