#####################################################
#	HeightTool.rb
#	by Robin Hill   Copyright 2004
#
#	VERSION 1.0
#
#
#	On loading this Script will set a menu item 'Add Height Text' in the Plugins Menu
#	On selecting  'Add Height Text' this will become the active tool
#	Hovering on a point will tell you its height above datum (ground plane)
#	Clicking with left mouse button will setup a text label with the height
#	Selecting another tool will stop this Height Tool being the active tool
#
#	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# 	IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# 	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#####################################################
class HeightTool

def activate					#called on first activation of tool - initialize here
    @ip = Sketchup::InputPoint.new
    @iptemp = Sketchup::InputPoint.new
    @displayed = false
    @pt=nil
    @vec=10,10,10				#set this for default length of leader to text label
end

def onMouseMove(flags, x, y, view)    
    @iptemp.pick view, x, y			# get a position in the model 
    if( @iptemp.valid? )
        changed = @iptemp != @ip
        @ip.copy! @iptemp
        pos = @ip.position;
        @pt=pos				#save position so it can be used in  onLButtonUp()
        msg = @ip.tooltip 			#start building tooltip message
        if( msg.length > 0 )
            msg << " "
        end
        msg << "߶Ϊ: "
	msg << pos.z.to_s
        view.tooltip = msg			# show message as tooltip
					# check if display needs update
        if( changed and (@ip.display? or @displayed) )         
            view.invalidate			#make the view update  
        end
    end
end

def onLButtonUp(flags, x, y, view)	#called when left mouse button released
    z=@pt.z
    txt='߶Ϊ: '
    txt<<z.to_s
    model=Sketchup.active_model
    e=model.entities
    t=e.add_text txt,@pt,@vec
end

end	#end of Class  HeightTool
#####################################################


