# Copyright 2004, Didier Bur

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

# Name :          links.rb
# Description :   Set,Get/Edit and opens URL and-or files for any object in SU model
# Author :        Didier Bur
# Usage :         
# Date :          28.Oct.2004
# Type :          Tool
# History:        1.0 (26.Oct.2004) - URL management
#                 1.1 (28.Oct.2004) - File management

require 'sketchup.rb'

def url_set
  model=Sketchup.active_model
  e = model.selection[0]
  #default values
  dict_key_url = "http://www--------------------------------------------------------------------------" if not dict_key_url
  # Retrieve url if any
  dict_name="link_data"
  dicts=e.attribute_dictionaries
  if( dicts!= nil and dicts[dict_name] )
    dict_key_url = e.get_attribute(dict_name, "url")
    else
    UI.messagebox("No URL set for this " + e.typename.to_s)
  end
    
  #Dialog box
  prompts=["URL  "]
  values=[dict_key_url]

  results = inputbox prompts, values
  return nil if not results
    
  dict_name="link_data"
  dict_key_url = results[0]
  e.attribute_dictionary(dict_name, true)
  e.set_attribute(dict_name,"url",dict_key_url)
end

def url_get
  model=Sketchup.active_model
  e = model.selection[0]
  dict_name="link_data"
  dicts=e.attribute_dictionaries
  if( (dicts != nil) and dicts[dict_name])
    UI.messagebox("URL: " + e.get_attribute(dict_name, "url"))
    else
    UI.messagebox("No URL set for this " + e.typename.to_s)
  end
end


def url_open
  model=Sketchup.active_model
  e = model.selection[0]
  dict_name="link_data"
  dicts=e.attribute_dictionaries
  if( (dicts != nil) and dicts[dict_name])
    dict_key_url = e.get_attribute("link_data", "url")
    UI.openURL(dict_key_url)
    else
    UI.messagebox("No URL set for this " + e.typename.to_s)
  end
end	

def file_set
  model=Sketchup.active_model
  e = model.selection[0]
  #default values
  dict_key_file = "------------------------------------------------------------------------------------" if not dict_key_file
  # Retrieve url if any
  dict_name="link_data"
  dicts=e.attribute_dictionaries
  if( dicts!= nil and dicts[dict_name] )
    dict_key_file = e.get_attribute(dict_name, "file")
    else
    UI.messagebox("No file set for this " + e.typename.to_s)
  end
    
  dict_key_file = UI.openpanel("Select the file you want to link to this object") 
  dict_name="link_data"
  e.attribute_dictionary(dict_name, true)
  e.set_attribute(dict_name,"file",dict_key_file)
end

def file_get
  model=Sketchup.active_model
  e = model.selection[0]
  dict_name="link_data"
  dicts=e.attribute_dictionaries
  if( (dicts != nil) and dicts[dict_name])
    UI.messagebox("File: " + e.get_attribute(dict_name, "file"))
    else
    UI.messagebox("No file set for this " + e.typename.to_s)
  end
end


def file_open
  model=Sketchup.active_model
  e = model.selection[0]
  dict_name="link_data"
  dicts=e.attribute_dictionaries
  if( (dicts != nil) and dicts[dict_name])
    dict_key_file = e.get_attribute("link_data", "file")
    UI.openURL("file://" + dict_key_file)
    else
    UI.messagebox("No file set for this " + e.typename.to_s)
  end
end	

if( not file_loaded?("links.rb") )
	UI.add_context_menu_handler do |menu|
		menu.add_separator
		submenu=menu.add_submenu(" ")
                        submenu.add_item(" ") { url_set }
			submenu.add_item("鿴Ϣ") { url_get }
                        submenu.add_item("ַ  ") { url_open }
                        submenu.add_separator
			submenu.add_item("ļ ") { file_set }
			submenu.add_item("鿴Ϣ") { file_get }
                        submenu.add_item("ļ") { file_open }
	end
end
#-----------------------------------------------------------------------------
file_loaded("links.rb")
