# Name :          Numb 1.2
# Description :   add consecutive numbers on click
# Author :        TBD
# Usage :         select from the menu, left click to add text,
#                 enter in VCB the start number, right click to change increment

# Date :          01.Jul.2oo4
# Type :          tool
# History:        1.1 (02.Jul.2oo4) - added support for right click (change increment)
#                 1.o (12.Jun.2oo4) - first version

class Numb

# initialize on tool activation
def activate
   @ip = Sketchup::InputPoint.new
   @iptemp = Sketchup::InputPoint.new
   @displayed = false
   @number = 1
   @increment = 1
end

# on MouseMove display InputPoint and update VCB
def onMouseMove(flags, x, y, view)
   # show VCB and status info
   Sketchup::set_status_text("Numb::Click to insert text", SB_PROMPT)
   Sketchup::set_status_text("Number", SB_VCB_LABEL)
   Sketchup::set_status_text("#{@number}", SB_VCB_VALUE)

   # get position in the model
   @iptemp.pick view, x, y

   if( @iptemp.valid? )
      changed = @iptemp != @ip
      @ip.copy! @iptemp

      @pos = @ip.position;

      # view update?
      if( changed and (@ip.display? or @displayed) )
         view.invalidate
      end
   end
end

# on left click add text
def onLButtonDown(flags, x, y, view)
   # add text
   Sketchup.active_model.entities.add_text(@number.to_s, @pos)
   @number = @number + @increment
end

# on right click add text
def onRButtonDown(flags, x, y, view)
   # display input dialog (inputbox needs array)
   result = inputbox ["Increment value"],[@increment]
   return if not result
   @increment = result[0]
end

# on user text in VCB modify number to be displayed
def onUserText(text,view)
   begin
      value = text.to_i
      rescue
      # Error parsing the text
      UI.beep
      value = nil
      Sketchup::set_status_text "", SB_VCB_VALUE
   end
   return if !value

   @number = value
end

# update the view
def draw(view)
   if( @ip.valid? && @ip.display? )
      @ip.draw view
      @displayed = true
   else
      @displayed = false
   end
end

end # class Numb

#----------------------------------------------------------------------------
# add menu items
#if( not $numb_menu_loaded )
#   add_separator_to_menu("Plugins")
#   UI.menu("Plugins").add_item("[TBD] Numb") { Sketchup.active_model.select_tool Numb.new }
#   $numb_menu_loaded = true
#end