# Name :	NumGrid 1.5.0
# Description :	Makes a numbered 2D grid of construction lines
# Author :	Jim Patrick
# Usage :	This script adds "Number Grid" to the Draw menu.
# 		Selecting this prompts for the overall and increment sizes.
# 		It also gives the option of placing the group on a seperate layer.
# Date :	25.Jul.2oo4
# Type :	tool
# History:	v1.00	Jim Patrick, SketchUp-user@jim-patrick.com, Copyright 2004
# 		v1.01	eliminate conflict with Box tool. Julie<aaa443@cox.net>
# 		v1.11	add numbering, other minor changes
# 		v1.5.0	add layer options, other minor changes
# To Do:	No error-checking at this point.
# 		A 100' X 100' grid can have a 9'-1 1/16" interval!
# 		Works in feet: US architectural and decimal feet only.
# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is granted, provided that the above
# copyright notice appear in all copies, and modified copies that work 
# are posted to the SketchUp?Forum.
# -----------------------------------------------------------------------------
# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY WARRANTIES
# *************NO WARRANTY MEANS NO WARRANTY******************
# -----------------------------------------------------------------------------

require 'sketchup.rb'

# -----------------------------------------------------------------------------

def create_NumGrid
	model = Sketchup.active_model
	saved_layer = model.active_layer

# Prompts and default values.
	prompts0 = ["Width  (x)", "Length (y)", "Interval"]
# Metric uses will want to change these defaults.
	values0 = [10000.mm, 10000.mm, 1000.mm]
	results0 = inputbox prompts0, values0, "Grid Size - NumGrid v1.5"
	width, length, interval = results0

# Start entity creation.
	model.start_operation "Numbered Grid"
	entities = model.active_entities
# -----------------------------------------------------------------------------
if results0 != false	# Graceful (!?) cancel to main inputbox
	set_layer_code = UI.messagebox("Put the grid on a Grid layer?", MB_YESNO)
	if set_layer_code == 6
			prompts1 = ["Layer name"]
			values1 = ["Grid"]
			results1 = inputbox prompts1, values1, "Grid Layer Name"
					if results1.to_s.empty? == true		# Deleted value handler
						results1 = model.layers.unique_name("Grid")
					elsif results1 == false
						results1 = saved_layer.name
					end
		model.layers.add(results1.to_s)
		model.active_layer = (results1.to_s)
	end
end
# -----------------------------------------------------------------------------
	group = entities.add_group
		model.active_layer = saved_layer
	entities = group.entities

# initialize step (stepped interval) , which will increment by the Interval
	step = []
	step[0] = 0
	step[1] = 0
	number = 0
	lstep = interval / 12
# Initialize the endpoints of the lines
	pts = []
	pts[0] = [0, step[0], 0]
	pts[1] = [width, 0, 0]
	pts[2] = [0, step[0], 0]
	pts[3] = [0, length, 0]

# Start drawing the clines.
# To get different linetypes, replace all "." with other stipples.
# Stipple choice is dashed "-", long dash "_", dashdot "-.-"
	while length >= (step[0] + interval)
		line1 = entities.add_cline(pts[0], pts[1], "." )
		step[0] = step[0] + interval
		pts[0] = [0, step[0], 0]
		pts[1] = [width, step[0], 0]
		number = number + lstep
		entities.add_text((number.to_i).to_s+"\'", pts[0])
	 end
# Add one more construction line to finish the rectangle
		line1 = entities.add_cline(pts[0], pts[1], "." )
		number = 0	# now reset text generator count
	while width >= (step[1] + interval)
	entities.add_text((number.to_i).to_s+"\'", pts[2])
		line2 = entities.add_cline(pts[2], pts[3], "." )
		step[1] = step[1] + interval
		pts[2] = [step[1], 0, 0]
		pts[3] = [step[1], length, 0]
		number = number + lstep
	 end
# Add one more construction line to finish the rectangle
		line2 = entities.add_cline(pts[2], pts[3], "." )
		entities.add_text((number.to_i).to_s+"\'", pts[2])

# Close/commit group
	model.commit_operation
view = model.active_view
view.zoom_extents
end

