# Copyright Didier Bur - 2004

# A personal license is granted to you to use this program freely

# You are not authorized to modify or copy this script
# to use at ends of trade

# This license does not imply any guarantee
# You use this program at your own risks

# For more information, please contact : bur@crai.archi.fr

#--------------------------------------------------------------------------
# pick a point for upper-left corner of text
# Import a ASCII text file as a single text block or line by line
# Layer selectable
# This tool is an alpha version of a more complete script
# still under development

# Take care for new versions
#--------------------------------------------------------------------------
# Versions history:
# 06.08.04: first release
#--------------------------------------------------------------------------


require 'sketchup.rb'

class Input_point

def activate					#called on first activation of tool - initialize here
    @ip = Sketchup::InputPoint.new
    @iptemp = Sketchup::InputPoint.new
    @displayed = false
    @pt=nil
    Sketchup::set_status_text("Pick point for upper-left corner of text", SB_PROMPT)
end

def onMouseMove(flags, x, y, view)    
    @iptemp.pick view, x, y			# get a position in the model 
    if( @iptemp.valid? )
        changed = @iptemp != @ip
        @ip.copy! @iptemp
        pos = @ip.position;
        @pt=pos				#save position so it can be used in  onLButtonUp()
        msg = @ip.tooltip 			#start building tooltip message
        if( msg.length > 0 )
            msg << " "
        end
        msg << " upper-left corner of text"
        view.tooltip = msg			# show message as tooltip
					# check if display needs update
        if( changed and (@ip.display? or @displayed) )         
            view.invalidate			#make the view update  
        end
    end
end

def onLButtonUp(flags, x, y, view)	#called when left mouse button released

# main prog starts here

  model = Sketchup.active_model
  saved_layer = model.active_layer
  e=model.entities
  
  value = UI.openpanel "Select text file" 

  if value

    ascii_text_File = File.new( value.to_s, "r" )                               #opens the input file
    
  
  #-----------------------------------------------------------------------------Layer settings
	set_layer_code = UI.messagebox("Put text on a layer ?", MB_YESNO)
	if set_layer_code == 6
			prompts1 = ["Layer name"]
			values1 = ["Text"]
			results1 = inputbox prompts1, values1, "Layer name"
					if results1.to_s.empty? == true	# Deleted value handler
						results1 = model.layers.unique_name("Text")
					elsif results1 == false
						results1 = saved_layer.name
					end
		model.layers.add(results1.to_s)
		model.active_layer = (results1.to_s)
	end
  #-----------------------------------------------------------------------------
  model.start_operation "Import ascii file"
  # process the file
  tableau_lignes = IO.readlines(value.to_s)
  
  #----------------------------------------------------------------------------- options selection
    @block_option = "Yes" if not @block_option
    @interval = 1 if not @interval
    block_option = ["Yes","No"]
    prompts = ["Create a single text block ? ","Interval "]
    values = [@block_option, @interval]
    enums = [block_option.join("|")]
    results = inputbox prompts, values, enums, "Text import options"
    return nil if not results
    
	@block_option = results[0]
        @interval = 0 - results[1]
        
  pt = @pt
  
  if( @block_option == "No" )
    #----------------------------------------------------------------------------- inserts lines one by one
    i = 0
    tableau_lignes.each do |text_line|
      t=e.add_text text_line,pt
      i = i + 1
      pt = [ 0, i * @interval, 0]
    end
  else
   #----------------------------------------------------------------------------- concat lines to text block
    concat_text = ""
    i = 0
    0.upto(tableau_lignes.length - 1) do |lll|
      concat_text = concat_text + tableau_lignes[i].to_s
      i = i + 1
    end    # of upto
    t=e.add_text concat_text,@pt
  end
 #----------------------------------------------------------------------------- 
  model.commit_operation   
  Sketchup::set_status_text("Import OK.", SB_PROMPT)  
    
      
    # close the file
    ascii_text_File.close
    else
      UI.messagebox "No file selected."
  end
end

end

#------------------------------------------------------------------------------------
#------------------------------------------------------------------------------------




# -----------------------------------------------------------------------------
#if( not file_loaded?("pick_import_text.rb") )

    # Add a separator to the menu, but only once
#    add_separator_to_menu("Plugins")
    #UI.menu("Plugins").add_item("Importer fichier texte") { import_ascii_file }
#    UI.menu("Plugins").add_item("Import text file") { Sketchup.active_model.select_tool Input_point.new }

#end

# -----------------------------------------------------------------------------
file_loaded("pick_import_text.rb")
  
  