# Copyright 2004, D. Bur, C. Fale

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------
# Name        :   points_cloud_triangulation
# Description :   A tool to create triangles starting from a construction points selection
# Menu Item   :   Plugins -> Triangulate points
# Context Menu:   NONE
# Usage       :   Select construction points. Select menu Plugins/Triangulate points
#             :   read the status bar to check information about triangulation
# Date        :   9/17/2004
# Type        :   Tool
#-----------------------------------------------------------------------------

require 'delauney/delauney.rb'


def points_to_array(z)
  z = 1
  model = Sketchup.active_model
  model.start_operation "points triangulation"
  entities = model.active_entities
  ss = model.selection

  if ss.empty? 
    UI.messagebox("No selection !")
    return nil
  end

  # Selection error checking: eliminates the non-cpoint objects
  look = 1
  i = 0
  0.upto( ss.length - 1) do |look|
    if( not ss[i].kind_of? Sketchup::ConstructionPoint )
      look = 0
    end
    i = i + 1
  end   #of upto

  #puts "Check: " + look.to_s + "\n"

  if(look == 0)
    UI.messagebox("Some object(s) of the selection aren't construction points.")
    return nil
  end
  
  i = 0
  # Fill an array of 3D_points with selection
  points_array = Array.new(ss.length)

    # read the points in the file and create the vertex array
    
    for ind in (0..(ss.length - 1))
      cpt = ss[i]
      x = cpt.position[0].to_f
      y = cpt.position[1].to_f
      z = cpt.position[2].to_f
      points_array[ind] = [x, y ,z]

      i = i + 1
    end
    
  #points_array = points_array[0..points_array.length - 4]
  
  return points_array
  
end #of def


def main

model = Sketchup.active_model
entities = model.active_entities
z = 0
triangles = []
points_table = points_to_array(z)


# Takes as input a array with NVERT lines, each line is a array with three values x, y, and z (vertex[j][0] = x value of j + 1 component)

if points_table
  triangles = triangulate(points_table)
end

i = 0
0.upto( triangles.length - 1 ) do |something|
  indices = triangles[i]
  ind1 = indices[0]
  ind2 = indices[1]
  ind3 = indices[2]
  
  # Verbose
  Sketchup.set_status_text("Adding triangle: "  + i.to_s + " / " + triangles.length.to_s )
  
  Sketchup.active_model.active_entities.add_face( points_table[indices[2]], points_table[indices[1]], points_table[indices[0]] )
  i = i + 1
end

end     #of def


#if( not file_loaded?("points_cloud_triangulation.rb") )
#    add_separator_to_menu("Plugins")
#    UI.menu("Plugins").add_item("Triangulate points") { main }
#end
file_loaded("points_cloud_triangulation.rb")
