#        Name : Pushpull_z
# Description : Extrudes a (set of) face(s) along a vector, not along the face normal
#      Author : Didier Bur
#       Usage : select  a line and face(s), select from the Plugins menu, and here you go
#               the extrusion along the vector depends on the direction the vector-line was drawn.
#        Date : 05.Aug.2oo4
#        Type : tool

require 'sketchup.rb'

def push_pull_vector

model = Sketchup.active_model
model.start_operation "Push Pull Vector"
entities = model.active_entities
ss = model.selection

if ss.empty? 
  UI.messagebox("No selection.")
  return nil
end
if (ss.length <= 1)
  UI.messagebox("Please select a vector line and face(s).")
  return nil
end

# Who is the vector and who are the faces ?
i = 0
indice_edge = 0
count_edge = 0
face_selected = 0
0.upto( ss.length - 1) do |something|
  element = ss[i]
  if( element.typename == "Edge")
    indice_edge = i
    count_edge = count_edge + 1
  end
  if( element.typename == "Face")
    face_selected = 1
  end
  i = i + 1
end # of upto

if( face_selected == 0 )
  UI.messagebox("Please select a face too.")
  return nil
end

if( count_edge > 1 )
  UI.messagebox("More than one vector have been selected.")
  return nil
end

vect = ss[indice_edge]

# Remove vect from selection
ss.remove(vect) 

# process each face
current_face = 0
#pts_vector = ss[0].vertices
pts_vector = vect.vertices

pt_vector_1 = pts_vector[0].position
pt_vector_2 = pts_vector[1].position

delta_x = pt_vector_2[0] - pt_vector_1[0]
delta_y = pt_vector_2[1] - pt_vector_1[1]
delta_z = pt_vector_2[2] - pt_vector_1[2]


0.upto(ss.length - 1) do |pts| 
  pts = ss[current_face].vertices
  length_pts = pts.length

  # copy the selected face
  i = 0
  pts2 = []

  pts.each do |pt|
    pts2[i] = pt.position + [delta_x , delta_y , delta_z]
    i = i +1
  end
  face_copy = entities.add_face pts2

  pts_copy = face_copy.vertices

  # create faces between pairs of vertices of each face
  i = 0
  j = 0

  0.upto(pts.length - 2) do |new_face| 
    new_face = entities.add_face(pts[i], pts_copy[i], pts_copy[i + 1], pts[i + 1])
    i = i + 1
  end    # of upto
  # close the shape
  new_face = entities.add_face(pts[pts.length - 1], pts_copy[pts.length - 1], pts_copy[0], pts[0])

current_face = current_face + 1
end     #end of upto faces

#That's all folks
model.commit_operation
end    # of def


#if( not file_loaded?("push_pull_vector.rb") )

    # This will add a separator to the menu, but only once
#    add_separator_to_menu("Plugins")
    
    # To add an item to a menu, you identify the menu, and then
    # provide a title to display and a block to execute.  In this case,
    # the block just calls the create_box function
#    UI.menu("Plugins").add_item("Push Pull faces along a vector") { push_pull_vector }

#end

#-----------------------------------------------------------------------------
file_loaded("push_pull_vector.rb")