# Copyright 2004, Todd Burch - Burchwood USA   http://www.burchwoodusa.com 

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

# Name :          scrtool.rb 1.0
# Description :   Left Click to reverse any faces.
# Author :        Todd Burch   http://www.burchwoodusa.com 
# Usage :         1. Active the Tool from the Tools Menu
#                 2. Left Click on any face to reverse it.
# Date :          11.Nov.2004
# Type :          Tool
# History:        1.0 (11.Nov.2004) - first version
#
#                                  
#-----------------------------------------------------------------------------
require 'sketchup.rb'

class ReverseFaceTool 

def initialize
  $ip = Sketchup::InputPoint.new                   # Define the variable. 
  end


def reset
  $ip.clear
  Sketchup::set_status_text "Left Click any Face to Reverse"   # Status Bar hint. 
  end

def activate
  self.reset
  end

def onMouseMove(flags, x, y, view)
  $ip.pick(view,x,y)                    # Get current Screen coordinates.
  view.tooltip = $ip.tooltip            # Set a tooltip if hovering over geometry.
  end


def onLButtonDown(flags, x, y, view)
  $ip.pick(view,x,y)                       # Get current screen coordinates.
  face = $ip.face                          # If hovering over a face, this will return the face definition.
  if (face != nil) then face.reverse! end  # if not nil (we have a face), then reverse the face. 
  end

end # class ReverseFaceTool 

#=============================================================================
def ReverseFaceTool
  Sketchup.active_model.select_tool ReverseFaceTool.new
end

if( not file_loaded?("scrtool.rb") )
   UI.add_context_menu_handler do |menu|
            menu.add_separator
            menu.add_item("ת湤 ") { Sketchup.active_model.select_tool ReverseFaceTool.new }
    end 
end
#-----------------------------------------------------------------------------
file_loaded("scrtool.rb")
