# Name:           StairConcTool
# Author :        Tim
# Description:    Create a Concrete Straight stair or a U shaped Concrete Stair with landing 
# Usage:          Change dialog box settings or accept defaults, click OK
#                 enter Next Floor Height to create new sets of stairs 
# Date:           2004,11,07
# Type:           Tool
#--------------------------------------------------------------------------
require 'sketchup.rb'

def stairconc
 
    #Set default stair settings
    $ccw = 36.inch if not $ccw
    $cch = 9.feet if not $cch
    $ccr = 16 if not $ccr
    $cct = 11.inch if not $cct
    $ccn = 1.25.inch if not $ccn
    $ccxh = 0.feet if not $ccxh 
       
    # Dialog box
    prompts = ["Stair Width", "Floor/Floor Height ", "No. Risers", "Tread Width", "Nosing", "Next Floor Height"]
    values = [$ccw, $cch, $ccr, $cct, $ccn, $ccxh]
    results = inputbox prompts, values, "Stair Properties"
    
    return if not results
    $ccw, $cch, $ccr, $cct, $ccn, $ccxh = results
    
    $ccincrt=$cch/$ccr
 #--------------------------------------------------------------------------
    model=Sketchup.active_model
    entities=model.active_entities
    group=entities.add_group
    entities=group.entities
   
    i=0
    j=0
    pt=[]
    pt[j]=[0, 0, $ccxh]
    xx=0
    yy=0
    zz=$ccxh

    while i < $ccr
       i=i+1
       j=j+1
       xx=xx-$ccn  
       zz=zz+$ccincrt 
       pt[j]=[xx, yy, zz]
       j=j+1
       xx=xx+$ccn+$cct
       pt[j]=[xx, yy, zz]
    end
    j=j+1
    pt[j]=[xx, yy, zz-$ccincrt]
    j=j+1
    pt[j]=[$cct, 0, $ccxh]

    base=entities.add_face pt
    base.pushpull $ccw
#---------------------------------------------------------------------------
    view=model.active_view
    view.zoom_extents
#---------------------------------------------------------------------------    
    model.commit_operation
end

 def stairconcu
    Sketchup::set_status_text("<<<<<< This Program creates a Scissor Stair with a Landing >>>>>", SB_PROMPT)
    #Set default stair settings
    $suw = 36.inch if not $suw
    $suh = 9.feet if not $suh
    $sur = 16 if not $sur
    $surl = 8 if not $surl
    $sut = 11.inch if not $sut
    $sun = 1.25.inch if not $sun
    $sunxh = 0.feet if not $sunxh 
    
    # Dialog box
    prompts = ["Stair Width", "Floor/Floor Height ", "No. Risers Total","No. Risers to Landing ", "Tread Width", "Nosing", "Next Floor Height"]
    values = [$suw, $suh, $sur, $surl, $sut, $sun, $sunxh]
    results = inputbox prompts, values, "U shaped Stair Properties"
        
    return if not results
    $suw, $suh, $sur, $surl, $sut, $sun, $sunxh = results
    
    if ($surl < 2)
       UI.messagebox( "Less than 2 risers is not allowed ")
    return nil
    end
    
    if ($surl >$sur-2)
       UI.messagebox( "Less than 2 risers after Landing is not allowed ")
    return nil
    end
    
    $suup=$sur-$surl 
    $suincr=$suh/$sur
#--------------------------------------------------------------------------
    model=Sketchup.active_model
    model.start_operation "Create Concrete Stair"
       
    #----Do lower stair drawing routine
    i=0
    j=0
    $all=[]
    $all[j]=[0, 0, $sunxh]
    $xx=0
    $yy=0
    $zz=$sunxh

    while i < $surl
       i=i+1
       j=j+1
       $xx=$xx-$sun  
       $zz=$zz+$suincr 
       $all[j]=[$xx, $yy, $zz]
       j=j+1
       $xx=$xx+$sun+$sut
       $all[j]=[$xx, $yy, $zz]
    end
    j=j+1
    $all[j]=[$xx, $yy, $zz-$suincr]
    j=j+1
    $all[j]=[$sut, 0, $sunxh]
    
    #----Points required to Do Landing 
    $pt1=Geom::Point3d.new($all[0])
    #$pt2=Geom::Point3d.new($pt1[0]+$sut,$pt1[1],$pt1[2])
    #$pt3=Geom::Point3d.new($pt1[0]+$sut*$surl,$pt1[1],$pt1[2])
    #$pt4=Geom::Point3d.new($pt1[0]+$sut*$surl,$pt1[1],$pt1[2]+($suincr*$surl)-$suincr)
    $pt5=Geom::Point3d.new($pt1[0]+$sut*$surl,$pt1[1],$pt1[2]+$suincr*$surl)
    $pt6=Geom::Point3d.new($pt1[0]+$sut*$surl-$sut,$pt1[1],$pt1[2]+$suincr*$surl)
    $pt7=Geom::Point3d.new($pt1[0]+$sut*$surl+$suw,$pt1[1]+$suw,$pt1[2]+$suincr*$surl)
    $pt8=Geom::Point3d.new($pt1[0]+$sut*$surl,$pt1[1]+$suw,$pt1[2]+$suincr*$surl)
    $pt9=Geom::Point3d.new($pt1[0]+$sut*$surl+$suw,$pt1[1]-$suw,$pt1[2]+$suincr*$surl)
    $pt0=Geom::Point3d.new($pt1[0]+$sut*$surl-$sut,$pt1[1]-$suw,$pt1[2]+$suincr*$surl)
     
    #----Points required to Do Landing opposing options 
    $pt11=Geom::Point3d.new($pt1[0]+$sut*$surl-$sut,$pt1[1]+$suw,$pt1[2]+$suincr*$surl)
    $pt22=Geom::Point3d.new($pt1[0]+$sut*$surl+$suw,$pt1[1],$pt1[2]+$suincr*$surl)
    $pt33=Geom::Point3d.new($pt1[0]+$sut*$surl+$suw-$sut,$pt1[1],$pt1[2]+$suincr*$surl)
    $pt44=Geom::Point3d.new($pt1[0]+$sut*$surl+$suw-$sut,$pt1[1]-$suw,$pt1[2]+$suincr*$surl)
    $pt55=Geom::Point3d.new($pt1[0]-$suw+$sut-($suup*$sut),$pt1[1],$pt1[2]+$suup*$suincr)
    $pt66=Geom::Point3d.new($pt1[0]-$suw+$sut-($suup*$sut),$pt1[1],$pt1[2]-$surl*$suincr)
        
    entities=model.active_entities
    group=entities.add_group
    entities=group.entities

    lower_base=entities.add_face $all
    lower_base.pushpull $suw 
    
        
    #----Do intermediate landing 
    entities=model.active_entities
    group=entities.add_group
    entities=group.entities
        
    land_base=entities.add_face($pt0, $pt6, $pt5, $pt8, $pt7, $pt9)
    land_base.pushpull $suincr
           
    #----Do upper stair drawing routine
    i=0
    j=0
    $all=[]
    $all[j]=[0, 0, 0]
    $xx=0
    $yy=0
    $zz=0

    while i < $sur-$surl
       i=i+1
       j=j+1
       $xx=$xx-$sun  
       $zz=$zz+$suincr 
       $all[j]=[$xx, $yy, $zz]
       j=j+1
       $xx=$xx+$sun+$sut
       $all[j]=[$xx, $yy, $zz]
    end
    j=j+1
    $all[j]=[$xx, $yy, $zz-$suincr]
    j=j+1
    $all[j]=[$sut, 0, 0]
           
    entities=model.active_entities
    group=entities.add_group
    entities=group.entities
    
    upper_base=entities.add_face $all
    upper_base.pushpull $suw 
    
    #----move upper stair drawing routine from [0,0,0] to input point $pt5
    t=Geom::Transformation.new($pt5)
    group.transform!(t)
    
    pi = 3.141592653589793   # 180 degree angle = pi radians
    #----rotate upper stair drawing routine about $pt5 180 degress
    tr=Geom::Transformation.rotation($pt5, Geom::Vector3d.new(0, 0 ,1), pi)
    group.transform!(tr)
#---------------------------------------------------------------------------
    view=model.active_view
    view.zoom_extents
#---------------------------------------------------------------------------     
    #----Do landing routine for Upper or Lower floors 
    #----Dialog box
    @choice = "UP one Floor" if not @choice
    choice_options = ["UP one Floor","DN one Floor"]
    prompts = ["Landing                "]
    values = [@choice]
    enums = [choice_options.join("|")]
    results = inputbox prompts, values, enums,"Create opposite Landing? "
    return if not results
    @choice = results[0]
      
    if @choice == "UP one Floor"  # Do Landing
    entities=model.active_entities  
    group=entities.add_group
    entities=group.entities
                  
    #----move landing from its original position to top of stair
    t=Geom::Transformation.new($pt55)
    group.transform!(t)
    base=entities.add_face($pt0, $pt11, $pt7, $pt22, $pt33, $pt44)
    base.pushpull $suincr
        
    else 
    entities=model.active_entities  
    group=entities.add_group
    entities=group.entities
                    
    #----move landing from its original position to btm of stair
    t=Geom::Transformation.new($pt66)
    group.transform!(t)
    base=entities.add_face($pt0, $pt11, $pt7, $pt22, $pt33, $pt44)
    base.pushpull $suincr
        
    end  # end of if 
#---------------------------------------------------------------------------
    view=model.active_view
    view.zoom_extents
#---------------------------------------------------------------------------    
    model.commit_operation
end
#---------------------------------------------------------------------------
if( not file_loaded?("StairConcTool") )
    utilities_menu = UI.menu("Plugins").add_submenu("Stairs")
         utilities_menu.add_item("Stair"){ create_stair }
         utilities_menu.add_item("Straight Stair") { stairconc }
         utilities_menu.add_item("Scissor Stair") { stairconcu }
	 utilities_menu.add_item("Spiral stair") { spiral_stair }

end
#---------------------------------------------------------------------------
file_loaded("StairConcTool.rb")
