#        Name : [CASF]Topo (v1.8)
# Description : Export Vertices from contour lines to a SurGe input file (*.dt*)
#             : Create a 3D Topo from a SurGe output file (*.gr*)
#             : Create a 3D Topo from data file using Delauney Trinagulation
#             : Create a 3D Topo from contour lines using Delauney Trinagulation
#      Author : Carlos Antnio dos Santos Fal (carlosfale@sapo.pt)
#   Thanks to : TBD for the help and tips
#             : Max for test the script
#       Usage : Run the script in Menu/Plugins/[CASF] Topo
#        Date : September.2oo4
#        Type : Create

# -----------------------------------------------------------------------------------------------------------------------------------------------

require 'sketchup.rb'
require 'delauney\delauney.rb'

# function that receive a string, path to a SurGe input file (*.dt*), and create a Points File
def create_dtfile_from_contour(str_file)

  t1 = Time.new
  puts "  READ SELECTION - START"
  # read all selected entities
  sel = Sketchup.active_model.selection

  # verify if selection is not nil
  if sel.length != 0
    @valid_sel = TRUE

    t2 = Time.new
    puts "  READ SELECTION - OK (#{t2 - t1} SEC)"

    t1 = Time.new
    puts "  EXTRACT VERTICES - START"
    # search only edges and extract the vertices
    vert = Array.new
    ind = 0
    for ent in sel
      if ent.class == Sketchup::Edge
        vert[ind] = ent.vertices[0]
        ind = ind + 1
        vert[ind] = ent.vertices[1]
        ind = ind + 1
      end
    end

    # verify if edges are not nil
    if vert.length != 0
      @valid_sel = TRUE

      # delete duplicated vertices
      vert.uniq!
      puts "    NUMBER OF VERTICES = #{vert.length}"

      t2 = Time.new
      puts "  EXTRACT VERTICES - OK (#{t2 - t1} SEC)"

      t1 = Time.new
      puts "  CREATE DTFILE - START"
      # open file to write the points
      aux_file = File.new(str_file, "w")
      aux_file.puts "# Created with SketchUp"
      aux_mult = 1
      for ind in (0..vert.length - 1)
        pt_x = vert[ind].position.x.to_f * 0.0254
        pt_y = vert[ind].position.y.to_f * 0.0254
        pt_z = vert[ind].position.z.to_f * 0.0254
        aux_file.puts "#{pt_x}  #{pt_y}  #{pt_z}  POINT#{ind + 1}"
      end
      aux_file.close

      t2 = Time.new
      puts "  CREATE DTFILE - OK (#{t2 - t1} SEC)"

    else
      @valid_sel = FALSE
      puts "    NO EDGES FOUND"
    end
  else
    @valid_sel = FALSE
    puts "    EMPTY SELECTION"
  end

end

# function that receive a string, path to a SurGe output file (*.gr*), and create a 3D Topo
def create_3dtopo_from_grfile(str_file)

  # open file, pass file to a array and close file
  t1 = Time.new
  puts "  OPEN FILE - START"
  aux_file = File.open(str_file, "r")
  table_lines = IO.readlines(str_file)
  aux_file.close
  t2 = Time.new
  puts "  OPEN FILE - OK (#{t2 - t1} SEC)"

  # confirm if the open file is valid
  if table_lines[0][0..3] == "DSAA"
    @valid_type = TRUE

    t1 = Time.new
    puts "  READ PARAMETERS - START"
    # read line 1 and put to description var
    desc = table_lines[0]
    puts "    DESCRIPTION = #{desc}"
    table_lines.delete_at 0

    # read line 2 and put to dimensions var, x dimension and y dimension
    dime = table_lines[0].split(pattern = " ")
    table_lines.delete_at 0
    puts "    DIMENSION X = #{dime[0]}"
    puts "    DIMENSION Y = #{dime[1]}"

    # read line 3 and put to minmaxX var, x minimum and x maximun, and calcule the x increment
    minmax_x = table_lines[0].split(pattern=" ")
    table_lines.delete_at 0
    incr_x = (minmax_x[1].to_f - minmax_x[0].to_f) / (dime[0].to_i - 1)
    puts "    MINIMUM X = #{minmax_x[0]}"
    puts "    MAXIMUM X = #{minmax_x[1]}"

    # read line 4 and put to minmaxY var, y minimum and y maximun and calcule the y increment
    minmax_y = table_lines[0].split(pattern=" ")
    table_lines.delete_at 0
    incr_y = (minmax_y[1].to_f - minmax_y[0].to_f) / (dime[1].to_i - 1)
    puts "    MINIMUM Y = #{minmax_y[0]}"
    puts "    MAXIMUM Y = #{minmax_y[1]}"

    # read line 5 and put to minmaxZ var, z minimum and z maximun
    minmax_z = table_lines[0].split(pattern=" ")
    table_lines.delete_at 0
    puts "    MINIMUM Z = #{minmax_z[0]}"
    puts "    MAXIMUM Z = #{minmax_z[1]}"

    t2 = Time.new
    puts "  READ PARAMETERS - OK (#{t2 - t1} SEC)"

    t1 = Time.new
    puts "  CREATE TABLE - START"
    # create mesh with 3DPoints
    mesh = Geom::PolygonMesh.new(dime[0].to_i * dime[1].to_i, 2 * (dime[0].to_i - 1) * (dime[1].to_i - 1))
    for ind_y in (0..dime[1].to_i - 1)
      valz = table_lines[ind_y].split(pattern=" ")
      for ind_x in (0..dime[0].to_i - 1)
        pt = Geom::Point3d.new((minmax_x[0].to_f + incr_x * ind_x) / 0.0254, (minmax_y[0].to_f + incr_y * ind_y) / 0.0254, valz[ind_x].to_f / 0.0254)
        mesh.add_point pt
      end
    end
    t2 = Time.new
    puts "  CREATE TABLE - OK (#{t2 - t1} SEC)"

    t1 = Time.new
    puts "  CREATE 3DTOPO - START"
    puts "    THIS OPERATION MAY TAKE A FEW MINUTES ..."
    puts "    PROGRESS IN STATUS BAR ..."
    # add polygons to mesh
    aux_dim = (dime[0].to_i - 1) * (dime[1].to_i - 1)
    aux_ind = 0
    for ind in (1..dime[0].to_i * dime[1].to_i)
      mod = ind.divmod dime[0].to_i
      if ((ind > 0) && (ind < dime[0].to_i * dime[1].to_i - dime[0].to_i) && (mod[1] != 0))
        aux_ind = aux_ind + 1
	Sketchup.set_status_text("TRIANGLE #{aux_ind} OF #{aux_dim}")
        mesh.add_polygon [ind + 1, ind + dime[0].to_i + 1, ind + dime[0].to_i]
        mesh.add_polygon [ind, ind + 1, ind + dime[0].to_i]
      end
    end

    t2 = Time.new
    puts "  CREATE 3DTOPO - OK (#{t2 - t1} SEC)"

    # draw the topo
    t1 = Time.new
    puts "  DRAW 3DTOPO - START"
    puts "    THIS OPERATION MAY TAKE A FEW MINUTES ..."
    group = Sketchup.active_model.active_entities.add_group

    entities = group.entities
    entities.add_faces_from_mesh mesh

    t2 = Time.new
    puts "  DRAW 3DTOPO - OK (#{t2 - t1} SEC)"
  else
    @valid_type = FALSE
    puts "    INCORRECT FILE TYPE"
  end

end

# procedure to create a triangulation of the selected file
def create_3dtopo_from_datafile_delauney(str_file)

  # open file, pass file to a array and close file
  t1 = Time.new
  puts "  OPEN FILE - START"
  aux_file = File.open(str_file, "r")
  table_lines = IO.readlines(str_file)
  aux_file.close
  t2 = Time.new
  puts "  OPEN FILE - OK (#{t2 - t1} SEC)"

  # confirm if the open file is valid
  if table_lines[0][0..9] == "DATAPOINTS"
    @valid_patt = TRUE

    # create table
    t1 = Time.new
    puts "  CREATE TABLE - START"
    puts "    THIS OPERATION MAY TAKE A FEW MINUTES ..."
    # delete line 1
    table_lines.delete_at 0

    # read the points in the file and create the vertex array
    vertex = Array.new(table_lines.length)
    for ind in (0..table_lines.length - 1)
      valz = table_lines[ind].split(pattern = ",")
      vertex[ind] = [valz[0].to_f, valz[1].to_f, valz[2].to_f]
    end

    puts "    DELAUNEY CALCULATION ..."
    #run delauney algorithm
    triangle = triangulate(vertex)
    vertex = vertex[0..vertex.length - 4]
    puts "    DELAUNEY CALCULATION OK"

    # create mesh with 3DPoints
    mesh = Geom::PolygonMesh.new(vertex.length, triangle.length)
    for ind in (0..vertex.length - 1)
      pt = Geom::Point3d.new(vertex[ind][0], vertex[ind][1], vertex[ind][2])
      mesh.add_point pt
    end

    t2 = Time.new
    puts "  CREATE TABLE - OK (#{t2 - t1} SEC)"

    t1 = Time.new
    puts "  CREATE 3DTOPO - START"
    puts "    THIS OPERATION MAY TAKE A FEW MINUTES ..."
    puts "    PROGRESS IN STATUS BAR ..."
    # add polygons to mesh
    for ind in (0..triangle.length - 1)
      Sketchup.set_status_text("TRIANGLE #{ind + 1} OF #{triangle.length}")
      mesh.add_polygon [triangle[ind][0] + 1, triangle[ind][2] + 1, triangle[ind][1] + 1]
    end

    t2 = Time.new
    puts "  CREATE 3DTOPO - OK (#{t2 - t1} SEC)"

    # draw the topo
    t1 = Time.new
    puts "  DRAW 3DTOPO - START"
    puts "    THIS OPERATION MAY TAKE A FEW MINUTES ..."
    group = Sketchup.active_model.active_entities.add_group

    entities = group.entities
    entities.add_faces_from_mesh mesh

    t2 = Time.new
    puts "  DRAW 3DTOPO - OK (#{t2 - t1} SEC)"
  else
    @valid_patt = FALSE
    puts "    INCORRECT FILE TYPE"
  end

end

# procedure to create a triangulation of the selected contours
def create_3dtopo_from_contour_delauney

  t1 = Time.new
  puts "  READ SELECTION - START"
  # read all selected entities
  sel = Sketchup.active_model.selection

  # verify if selection is not nil
  if sel.length != 0
    @valid_triang = TRUE

    t2 = Time.new
    puts "  READ SELECTION - OK (#{t2 - t1} SEC)"

    t1 = Time.new
    puts "  EXTRACT VERTICES - START"
    # search only edges and extract the vertices
    vert = Array.new
    ind = 0
    for ent in sel
      if ent.class == Sketchup::Edge
        vert[ind] = ent.vertices[0]
        ind = ind + 1
        vert[ind] = ent.vertices[1]
        ind = ind + 1
      end
    end

    # verify if edges are not nil
    if vert.length != 0
      @valid_triang = TRUE

      # delete duplicated vertices
      vert.uniq!
      puts "    NUMBER OF VERTICES = #{vert.length}"

      t2 = Time.new
      puts "  EXTRACT VERTICES - OK (#{t2 - t1} SEC)"

      t1 = Time.new
      puts "  CREATE TABLE - START"
      puts "    THIS OPERATION MAY TAKE A FEW MINUTES ..."
      # create table
      vertex = Array.new(vert.length)
      for ind in (0..vert.length - 1)
        vertex[ind] = [vert[ind].position.x.to_f, vert[ind].position.y.to_f, vert[ind].position.z.to_f]
      end

      puts "    DELAUNEY CALCULATION ..."
      #run delauney algorithm
      triangle = triangulate(vertex)
      vertex = vertex[0..vertex.length - 4]
      puts "    DELAUNEY CALCULATION OK"

      # create mesh with 3DPoints
      mesh = Geom::PolygonMesh.new(vertex.length, triangle.length)
      for ind in (0..vertex.length - 1)
        pt = Geom::Point3d.new(vertex[ind][0], vertex[ind][1], vertex[ind][2])
        mesh.add_point pt
      end

      t2 = Time.new
      puts "  CREATE TABLE - OK (#{t2 - t1} SEC)"

      t1 = Time.new
      puts "  CREATE 3DTOPO - START"
      puts "    THIS OPERATION MAY TAKE A FEW MINUTES ..."
      puts "    PROGRESS IN STATUS BAR ..."
      # add polygons to mesh
      for ind in (0..triangle.length - 1)
        Sketchup.set_status_text("TRIANGLE #{ind + 1} OF #{triangle.length}")
        mesh.add_polygon [triangle[ind][0] + 1, triangle[ind][2] + 1, triangle[ind][1] + 1]
      end

      t2 = Time.new
      puts "  CREATE 3DTOPO - OK (#{t2 - t1} SEC)"

      # draw the topo
      t1 = Time.new
      puts "  DRAW 3DTOPO - START"
      puts "    THIS OPERATION MAY TAKE A FEW MINUTES ..."
      group = Sketchup.active_model.active_entities.add_group

      entities = group.entities
      entities.add_faces_from_mesh mesh

      t2 = Time.new
      puts "  DRAW 3DTOPO - OK (#{t2 - t1} SEC)"
    else
      @valid_triang = FALSE
      puts "    NO EDGES FOUND"
    end
  else
    @valid_triang = FALSE
    puts "    EMPTY SELECTION"
  end

end

# procedure to run the create_file_from_contour function of a chosen file (*.dt*)
def create_dtfile

  # run open dialog to chose a file
  value = UI.openpanel("Select DataPoints File", "", "*.dt*")

  if value
    puts
    puts "DTFILE OPERATION - START"
    st = Time.new
    create_dtfile_from_contour(value.to_s)
    et = Time.new
    if @valid_sel
      puts "DTFILE OPERATION - OK (#{et - st} SEC)"
    else
      puts "DTFILE OPERATION - STOP (#{et - st} SEC)"
    end
    puts
  else
    UI.messagebox "No DataPoints File Selected."
  end

end

# procedure to run the create_topo_from_file function of a chosen file (*.gr*)
def create_3dtopo_1

  # run open dialog to chose a file
  value = UI.openpanel("Select Data3DGrid File", "", "*.gr*")

  if value
    puts
    puts "3DTOPO OPERATION - START"
    st = Time.new
    create_3dtopo_from_grfile(value.to_s)
    et = Time.new
    if @valid_type
      puts "3DTOPO OPERATION - OK (#{et - st} SEC)"
    else
      puts "3DTOPO OPERATION - STOP (#{et - st} SEC)"
    end
    puts
  else
    UI.messagebox "No Data3DGrid File Selected."
  end

end

# create_3dtopo_from_datafile_delauney
def create_3dtopo_2

  # run open dialog to chose a file
  value = UI.openpanel("Select Data File", "", "*.txt")

  if value
    puts
    puts "3DTOPO OPERATION - START"
    st = Time.new
    create_3dtopo_from_datafile_delauney(value.to_s)
    et = Time.new
    if @valid_patt
      puts "3DTOPO OPERATION - OK (#{et - st} SEC)"
    else
      puts "3DTOPO OPERATION - STOP (#{et - st} SEC)"
    end
    puts
  else
    UI.messagebox "No Data3DGrid File Selected."
  end

end

# create_3dtopo_from_contour_delauney
def create_3dtopo_3

  puts
  puts "3DTOPO OPERATION - START"
  st = Time.new
  create_3dtopo_from_contour_delauney
  et = Time.new
  if @valid_triang
    puts "3DTOPO OPERATION - OK (#{et - st} SEC)"
  else
    puts "3DTOPO OPERATION - STOP (#{et - st} SEC)"
  end
  puts
  else

end

# create entries in menu if the script is not loaded yet
#if (not file_loaded?("[CASF]Topo.rb"))
#  CASF_menu = UI.menu("Plugins").add_submenu("[CASF] Topo")
#  CASF_menu.add_item("Create DTFile from Contour") {create_dtfile}
#  CASF_menu.add_item("Create 3DTopo from GRFile") {create_3dtopo_1}
#  CASF_menu.add_separator
#  CASF_menu.add_item("Create 3DTopo from Data File") {create_3dtopo_2}
#  CASF_menu.add_item("Create 3DTopo from Contour") {create_3dtopo_3}
#  CASF_menu.add_separator 
#  CASF_menu.add_item("Surge Help (Online)") {UI.openURL("http://www.geocities.com/miroslavdressler/surgemain.htm")}
#end

# -----------------------------------------------------------------------------------------------------------------------------------------------

# load the script
file_loaded("Topo.rb")