# Copyright 2004, Rick Wilson

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------
# Name        :   Isolate Text 1.0
# Description :   A script to isolate all text on a separate layer
# Menu Item   :   Plugins->Isolate Text
# Usage       :   Select "Isolate Text" from the Plugins menu.
#             :   All text items will be placed on a layer "Text". 
# Date        :   10/13/2004
# Type        :   
#-----------------------------------------------------------------------------

require 'sketchup.rb'

def isolateText
	model=Sketchup.active_model
	ents=model.active_entities
	countText=countMoved=0
	model.start_operation "isolateText"
	txtLayer=model.layers.add("Text").name
	for e in ents
		if e.class==Sketchup::Text
			countText+=1
			puts e.layer.name
			if e.layer.name != txtLayer
				e.layer=txtLayer
				countMoved+=1
			end
		end
	end
	model.commit_operation
	UI.messagebox(countText.to_s+" text items found, "+countMoved.to_s+" moved to layer \"Text\".")
end

#if( not file_loaded?("isotext.rb") )
#    add_separator_to_menu("Plugins")
#    UI.menu("Plugins").add_item("Isolate Text") { isolateText }
#end
#-----------------------------------------------------------------------------
file_loaded("isotext.rb")
