require 'sketchup.rb'
# (c) Carlo Roosen 2004

def repair_broken_lines
  model = Sketchup.active_model
  #define everything as one undo operation
  model.start_operation "Repair Broken Lines"

  trunk = Array.new
  ss = model.selection
  #search all edges in selection set
  for e in ss
    if (e.kind_of?(Sketchup::Edge))
      p=e.parent
      #take both vertices 
      for v in e.vertices 
        #take all edges connected to v (including e)
        es=v.edges
        #when two edges are connected
        if (es.length==2)
          vec1 = es[0].line[1]
          vec2 = es[1].line[1]
          #and both are in the same direction
          if (vec1.parallel?(vec2))
            #then the two lines can be repaired
            #this is done by generating a new line from the vertex to a random point
            l = p.entities.add_line (v.position, Geom::Point3d.new(3.45,6.78,9.12))
            #and put that line in a trunk
            trunk.push(l)
          end
        end
      end
    end
  end

  #erase all lines in trunk
  total = trunk.length
  for l in trunk
    l.erase!
  end
  model.commit_operation
  UI.messagebox ("#{total} lines repared")
end

#if( not file_loaded?("repair_broken_lines.rb") )
#  UI.menu("Plugins").add_item("Repair Broken Lines") { repair_broken_lines }
#end

file_loaded "repair_broken_lines.rb"

    
  