# Copyright Christophe Hbert - 2004

# A personal license is granted to you to use this program freely

# You are not authorized to modify or copy this script
# to use at ends of trade

# This license does not imply any guarantee
# You use this program at your own risks

# For more information, please contact : archetyp@online.fr
#                                        http://archetyp.online.fr

#--------------------------------------------------------------------------
# Archetypes Elements for SketchUp

# This tool is an alpha version of a concrete straight stair maker
# still under development

# Version ArchetypesStairMaker Alpha 0.65

# Take care for new versions
#--------------------------------------------------------------------------

require 'sketchup.rb'

#--------------------------------------------------------------------------

 def archetypesElements_straightConcreteStair
       
    # Entre des variables de construction de l'escalier
    prompts = ["Stair width", "Stair Height", " step riser", "step tread", "Edge of step"]
    
    values = [1.m, 2.7.m, 0.16.m, 0.28.m, 3.8.cm]
    
    results = inputbox prompts, values, "Concrete Stair definition"
    stairWidth, height, riser, tread, stepEdge = results

    # Ajustement de la hauteur de marche
    increment = height/riser
    riser = height/increment.round

    increment = height/riser

#--------------------------------------------------------------------------

    # Dbut de creation de l'entit
    model = Sketchup.active_model
    model.start_operation "Create Straight Concrete Stair"

    entities = model.active_entities
#--------------------------------------------------------------------------
    # Cration du gabarit de la marche
    group = entities.add_group
    entities = group.entities

    vectNez = Geom::Vector3d.new(-stepEdge, 0, riser)
    vectGiron = Geom::Vector3d.new(stepEdge +tread, 0, 0)


#--------------------------------------------------------------------------
    # Cration du profil de l'escalier

    group = entities.add_group
    entities = group.entities


    i = 0
    j = 0

    pts = []

    pts[j] = [0, 0, 0]
    xm = 0
    ym = 0
    zm = 0

    while i < increment
       i = i + 1

       j = j + 1
       xm = xm - stepEdge
       zm = zm + riser
       pts[j] = [ xm, ym, zm]


       j = j + 1
       xm = xm + stepEdge + tread
       pts[j] = [ xm, ym, zm]

    end

    j = j + 1
    pts[j] = [ xm, ym, zm - riser]

    j = j + 1
    pts[j] = [ tread, 0, 0]




    profileStep = entities.add_face pts
    # peinture blanche
    # profileStep.material = Sketchup::Color.new(255, 255, 255) 

    profileStep.pushpull stairWidth



# Fin du groupe / fin de l'opration
    model.commit_operation
end

#--------------------------------------------------------------------------

# Ajouter la fonction au sous-menu rserv "Archetypes Elements"
# Test si le script a t dj charg comme plug-in
if( not file_loaded?("ArchetypesStairMaker.rb") )

    submenu = UI.menu("Tools").add_submenu("StairMaker") 
    submenu.add_item("Concrete straight stair") { archetypesElements_straightConcreteStair }

end


#--------------------------------------------------------------------------
#--------------------------------------------------------------------------
#--------------------------------------------------------------------------
#--------------------------------------------------------------------------


 def archetypesElements_straightSteelStair
       
    # Prompts and default values.
    prompts = ["Stair width", "Stair Height", " step riser", "step tread"]
    
    # Metric uses will want to change these defaults.
    values = [1.m, 2.7.m, 0.16.m, 0.28.m]

    results = inputbox prompts, values, "Stair definition"
    stairWidth, height, riser, tread = results
    e = 4.cm

    # Ajustement de la hauteur de marche
    increment = height/riser
    riser = height/increment.round

    increment = height/riser

#--------------------------------------------------------------------------

    # Start entity creation.
    model = Sketchup.active_model
    model.start_operation "Create Straight Steel Stair"

#--------------------------------------------------------------------------

    # Cration d'une marche

    definitions = model.definitions
    marche = definitions.add

    entities = marche.entities

    pts = []   
    pts[0] = [0, 0, 0]
    pts[1] = [0, 0, e]
    pts[2] = [tread + 5.cm, 0, e]
    pts[3] = [tread + 5.cm, 0, 0]

    profileStep = entities.add_face pts
    # peinture blanche
    # profileStep.material = Sketchup::Color.new(255, 255, 255) 
    profileStep.pushpull stairWidth

#--------------------------------------------------------------------------

    # Position de la premire marche  la bonne hauteur
    t = Geom::Transformation.translation (Geom::Vector3d.new(0, 0, riser-e))

    # Cration du groupe de l'escalier
    entities = model.active_entities
    #group = entities.add_group
    #entities = group.entities

    # Cration de la premire marche
    entities.add_instance(marche, t)


    # Copie et Position des marches suivantes...
    i = 1
    while i < increment
       # Transformation, incrmentation
       i = i + 1
       t = Geom::Transformation.translation (Geom::Vector3d.new(tread*(i-1), 0, (riser*i)-e))
       entities.add_instance(marche, t)
    end


# Close/commit group
    model.commit_operation
end

#--------------------------------------------------------------------------

# Ajouter la fonction au sous-menu rserv "Archetypes Elements"
# First check for existing menu load
if( not file_loaded?("ArchetypesStraightSteelStair.rb") )

    submenu.add_item("Steel straight stair") { archetypesElements_straightSteelStair }

end

#--------------------------------------------------------------------------
#--------------------------------------------------------------------------
#--------------------------------------------------------------------------
#--------------------------------------------------------------------------
#--------------------------------------------------------------------------


 def archetypesElements_straightWoodStair
       
    # Prompts and default values.
    prompts = ["Stair width", "Stair Height", " step riser", "step tread"]
    
    # Metric uses will want to change these defaults.
    values = [1.m, 2.7.m, 0.16.m, 0.28.m]

    results = inputbox prompts, values, "Stair definition"
    stairWidth, height, riser, tread = results
    e = 4.cm

    # Ajustement de la hauteur de marche
    increment = height/riser
    riser = height/increment.round

    increment = height/riser

#--------------------------------------------------------------------------

    # Start entity creation.
    model = Sketchup.active_model
    model.start_operation "Create Straight Steel Stair"

#--------------------------------------------------------------------------

    # Cration d'une marche

    definitions = model.definitions
    contremarche = definitions.add

    entities = contremarche.entities

    pts = []   
    pts[0] = [0, 0, 0]
    pts[1] = [0, 0, e]
    pts[2] = [tread + (5.cm*2), 0, e]
    pts[3] = [tread + (5.cm*2), 0, 0]

    profileStep = entities.add_face pts
    # peinture blanche
    # profileStep.material = Sketchup::Color.new(255, 255, 255) 
    profileStep.pushpull stairWidth
#--------------------------------------------------------------------------

    # Cration d'une contre-marche

    definitions = model.definitions
    marche = definitions.add

    entities = marche.entities

    pts = []   
    pts[0] = [0+ 5.cm, 0, 0]
    pts[1] = [e+ 5.cm, 0, 0]
    pts[2] = [e+ 5.cm, 0, -(riser-e)]
    pts[3] = [0+ 5.cm, 0, -(riser-e)]

    profileContremarche = entities.add_face pts
    # peinture blanche
    # profileContremarche.material = Sketchup::Color.new(255, 255, 255) 
    profileContremarche.pushpull stairWidth


#--------------------------------------------------------------------------

    # Position de la premire marche  la bonne hauteur
    t = Geom::Transformation.translation (Geom::Vector3d.new(0, 0, riser-e))

    # Cration d'une marche
    entities = model.active_entities


    entities.add_instance(marche, t)
    entities.add_instance(contremarche, t)



    # Copie et Position des marches suivantes...
    i = 1
    while i < increment
       # Transformation, incrmentation
       i = i + 1
       t = Geom::Transformation.translation (Geom::Vector3d.new(tread*(i-1), 0, (riser*i)-e))
       entities.add_instance(marche, t)
       entities.add_instance(contremarche, t)
    end


# Close/commit group
    model.commit_operation
end

#--------------------------------------------------------------------------

# Ajouter la fonction au sous-menu rserv "Archetypes Elements"
# First check for existing menu load
if( not file_loaded?("ArchetypesStraightWoodStair.rb") )

    submenu.add_item("Wood straight stair") { archetypesElements_straightWoodStair }

end

#--------------------------------------------------------------------------

file_loaded("ArchetypesStairMaker.rb")

