# Name :          Stitcher 1.1
# Description :   stitches 2 faces together
# Author :        RW
# Usage :         select 2 faces - edges & faces will be
#                 created between them
# Date :          27.Jul.2004
# Type :		tool
# History:
#			1.1 (28.Jul.2004) - added function to account for
#						  different #s of edges
#			1.0 (27.Jul.2004) - first version

require 'sketchup.rb'

def stitch_faces
#	CHECK THE SELECTIONS
	model = Sketchup.active_model
	entities = model.active_entities
	ss = model.selection
	if ((ss.length != 2) || ((ss[0].class != Sketchup::Face) && (ss[1].class != Sketchup::Face)))
		UI.messagebox("Please select only 2 faces")
		return
	end

	if ((ss[0].vertices.length) > (ss[1].vertices.length))
		face1 = ss[0]
		face2 = ss[1]
	else
		face1 = ss[1]
		face2 = ss[0]
	end
	face1q = face1.vertices.length
	face2q = face2.vertices.length
	b = (face1q.to_f-face2q.to_f)/face1q
#	print b

	model.start_operation "Stitcher"
#	if (face1q != face2q)
		0.upto(face1.vertices.length) do |a|
			c = (a* b).to_i
		print "\n"+c.to_s
			entities.add_line(face1.vertices[a-1].position,face2.vertices[(a-1)-c].position)
			entities[entities.length-1].find_faces if (entities[entities.length-1].class == Sketchup::Edge)
		#print("\nAdding line" + (a+2).to_s)
			entities.add_line(face1.vertices[a].position,face2.vertices[(a-1)-c].position)
			entities[entities.length-1].find_faces if (entities[entities.length-1].class == Sketchup::Edge)
		#print("\nAdding line" + (a+2).to_s + "b")
		end
#	else


#	end
	entities.add_line(face1.vertices[-1].position,face2.vertices[0].position)
	if (entities[entities.length-1].class == Sketchup::Edge)
		entities[entities.length-1].find_faces
	end
		
	model.commit_operation

end

#if( not file_loaded?("stitcher.rb") )

    # This will add a separator to the menu, but only once
    #add_separator_to_menu("Plugins")
    
    # To add an item to a menu, you identify the menu, and then
    # provide a title to display and a block to execute.  In this case,
    # the block just calls the create_box function
    #UI.menu("Plugins").add_item("") { stitch_faces }

#end

#-----------------------------------------------------------------------------
file_loaded("stitcher.rb")

