# Copyright 2004, ODM  www.AITOP.com
# thanks  Rick Wilson 

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

# Name :          groupByTexture.rb 1.0
# Description :   Explodes groups/components, regroups faces by material. Dispatch Component/Group by texture
# Author :        Rick Wilson
# Usage :         1. Install into the plugins directory or into the 
#                    Plugins/examples directory and manually load from the ruby console "load 'examples/groupByTexture.rb'" 
#                 2. Run "Group by texture" from the Plugins menu.
# Date :          22.Dec.2004
                 # ODM update 19.Apr.2005  add Component/Group by texture
# Type :          Tool
# History:        1.0 (22.Dec.2004) - first version
#
 
require 'sketchup.rb'

def texture_groups
	model=Sketchup.active_model
	ents=model.active_entities
	sel=model.selection
	comgrp=[]
	mats=model.materials
	matNames=[]
	mats.each {|m| matNames.push(m.name)}

	model.start_operation "Bomb"

	0.upto(ents.length) do |a|
#		FIND GROUPS AND COMPONENTS
		comgrp[comgrp.length] = ents[a] if (ents[a].class == Sketchup::Group) 
	end

#		EXPLODE GROUP OR COMPONENT
	0.upto(comgrp.length-1) do |a|
		comgrp[a].explode
	end

	model.commit_operation

#		SORT BY MATERIAL

	model.start_operation "Group by texture"

	noMat=[]
	matNames.each do |m|
		sel.clear
		ents.each do |ee|
			if ee.class == Sketchup::Face
				if ee.material
					sel.add(ee) if ee.material.name == m
				else
					noMat.push(ee)
				end
			end
		end
		ents.add_group(sel)
	end
	sel.clear
	noMat.each {|nm| sel.add(nm)}
	ents.add_group(sel)

	model.commit_operation
end

def texture_coms
	model=Sketchup.active_model
	ents=model.active_entities
	sel=model.selection
	comgrp=[]
	mats=model.materials
	matNames=[]
	mats.each {|m| matNames.push(m.name)}

	model.start_operation "Bomb"

	0.upto(ents.length) do |a|
#		FIND GROUPS AND COMPONENTS
		comgrp[comgrp.length] = ents[a] if  ((ents[a].class == Sketchup::Group) || (ents[a].class == Sketchup::ComponentInstance))
	end

#		EXPLODE GROUP OR COMPONENT
	0.upto(comgrp.length-1) do |a|
		comgrp[a].explode
	end

	model.commit_operation

#		SORT BY MATERIAL

	model.start_operation "Component/Group by texture"

	noMat=[]
	matNames.each do |m|
		sel.clear
		ents.each do |ee|
			if ee.class == Sketchup::Face
				if ee.material
					sel.add(ee) if ee.material.name == m
				else
					noMat.push(ee)
				end
			end
		end
		ents.add_group(sel)
	end
	sel.clear
	noMat.each {|nm| sel.add(nm)}
	ents.add_group(sel)

	model.commit_operation
end

def texture_Layer_groups
	model=Sketchup.active_model
	ents=model.active_entities
	sel=model.selection
	comgrp=[]
	mats=model.materials
	matNames=[]
	mats.each {|m| matNames.push(m.name)}

	model.start_operation "Bomb"

	0.upto(ents.length) do |a|
#		FIND GROUPS AND COMPONENTS
		comgrp[comgrp.length] = ents[a] if (ents[a].class == Sketchup::Group) 
	end

#		EXPLODE GROUP OR COMPONENT
	0.upto(comgrp.length-1) do |a|
		comgrp[a].explode
	end

	model.commit_operation

#		SORT BY MATERIAL

	model.start_operation "Dispatch Group by texture"
        countText=countTextMoved=0
	noMat=[]
	matNames.each do |m|
		sel.clear
		ents.each do |ee|
			if ee.class == Sketchup::Face
				if ee.material
				        countText+=1
					sel.add(ee) if ee.material.name == m
					mod_layer=model.layers.add("#{ee.material.name}")
					if ee.layer.name != mod_layer
					         ee.layer=mod_layer
						 countTextMoved+=1
	                                end
				else
					noMat.push(ee)
				end
			end
		end
		ents.add_group(sel)
		
		
	end
	sel.clear
	noMat.each {|nm| 
	     sel.add(nm)
	     mod_layer=model.layers.add("Default Layer").name
	     if nm.layer.name != mod_layer
		nm.layer=mod_layer
		countTextMoved+=1
	    end
	    }
	ents.add_group(sel)
	model.commit_operation

end

def texture_Layer_coms
	model=Sketchup.active_model
	ents=model.active_entities
	sel=model.selection
	comgrp=[]
	mats=model.materials
	matNames=[]
	mats.each {|m| matNames.push(m.name)}

	model.start_operation "Bomb"

	0.upto(ents.length) do |a|
#		FIND GROUPS AND COMPONENTS
		comgrp[comgrp.length] = ents[a] if ((ents[a].class == Sketchup::Group) || (ents[a].class == Sketchup::ComponentInstance))
	end

#		EXPLODE GROUP OR COMPONENT
	0.upto(comgrp.length-1) do |a|
		comgrp[a].explode
	end

	model.commit_operation

#		SORT BY MATERIAL

	model.start_operation "Dispatch Component/Group by texture"
        countText=countTextMoved=0
	noMat=[]
	matNames.each do |m|
		sel.clear
		ents.each do |ee|
			if ee.class == Sketchup::Face
				if ee.material
				        countText+=1
					sel.add(ee) if ee.material.name == m
					sel.add(ee.edges) if ee.material.name == m
					mod_layer=model.layers.add("#{ee.material.name}")
					if ee.layer.name != mod_layer
					         ee.layer=mod_layer
						countTextMoved+=1
	                                end
				else
					noMat.push(ee)
				end
			end
		end
		ents.add_group(sel)
		
		
	end
	sel.clear
	noMat.each {|nm| 
	     sel.add(nm)
	     mod_layer=model.layers.add("Default Layer").name
	     if nm.layer.name != mod_layer
		nm.layer=mod_layer
		countTextMoved+=1
	    end
	    }
	ents.add_group(sel)
	model.commit_operation

end

if( not file_loaded?("groupByTexture.rb") )
    add_separator_to_menu("Plugins")
    mode_menu= UI.menu("Plugins").add_submenu ("ģͱ")
    mode_menu.add_item("ʱ") { texture_groups }
    mode_menu.add_item("/ʱ") { texture_coms }
    mode_menu.add_item("ʷ") { texture_Layer_groups}
    mode_menu.add_item("/ʱ") { texture_Layer_coms}
end
#-----------------------------------------------------------------------------
file_loaded("groupByTexture.rb")
