# Copyright 2005, Todd Burch - Burchwood USA   http://www.burchwoodusa.com 

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

# Name :          group_rename.rb 1.0
# Description :   Rename Groups and Components.
# Author :        Todd Burch   http://www.burchwoodusa.com 
# Usage :         1. Select Group(s) and/or Component(s)
#                 2. Right Click and pick "Rename" or choose Rename from the Plugins Menu.
#                    Right Click only works when 1 group or component is selected.  Use the Plugin 
#                    method for a multi-selection.   You will be prompted for each rename, one at a time.
# Date :          27.Mar.2005
# Type :          Plugin
# History:        1.0 (27.Mar.2005) - first version
#
#                                  
#-----------------------------------------------------------------------------
require 'sketchup.rb' 

class GRN  # Group ReName  

def GRN.nameNew(name,type) 
  prompt = ["ǰ #{name}"] 
  value = [name] ; 
  result = UI.inputbox(prompt, value, "#{type} Rename") ; 
  return nil if !result   
  return nil if result[0]==name        # If not changed, return nil. 
  return result[0] ;                   # Return the new name.
  end 

def GRN.nameGroup 
  as = Array.new
  as = Sketchup.active_model.selection.collect   # Remember the user's selection. 
  return if (as==0 || !as)                       # If nothing, leave. 
  as.each {|g| 
    Sketchup.active_model.selection.clear   # Empty the current selection 
    Sketchup.active_model.selection.add(g)  # Put focus on the thing we're renaming. 
    newname = nil ;                         # Establish variable scope/visibility. 
    if (g.is_a? Sketchup::Group) 
      newname=GRN.nameNew(g.name,g.class) ; 
      next if (!newname)                    # if not changed, we're done. 
      g.name=newname ;                      # Set the new name. 
     elsif (g.is_a? Sketchup::ComponentInstance) 
       newname=GRN.nameNew(g.definition.name,g.class) ; 
       next if (!newname)                   # if not changed, we're done. 
       g.definition.name=newname ;          # Set the new name. 
       end 
     } 
   Sketchup.active_model.selection.clear    # Empty the current selection 
   end  # def nameGroup 
 
def GRN.got_group 
  if (Sketchup.active_model.selection.single_object?) 
    e = Sketchup.active_model.selection[0] ;
    return true if ((e.is_a? Sketchup::Group) || (e.is_a? Sketchup::ComponentInstance)) 
    end 
  return false 
  end 
end # class GRN 

if( not file_loaded?("group_rename.rb") )
  UI.menu("Plugins").add_item("/") { GRN.nameGroup }
  UI.add_context_menu_handler do |menu|
    if (GRN.got_group) 
      obj = Sketchup.active_model.selection[0] ; 
      name=nil ; 
      if (obj.is_a? Sketchup::Group) then name = "#{obj.name}"  
      else name = "#{obj.definition.name}" 
        end   
      menu.add_item(" #{name}?")   { GRN.nameGroup }
      end  # if got_group
    end # do menu 
  end   # file_loaded? 
#-----------------------------------------------------------------------------
file_loaded("group_rename.rb")