# Copyright 2005, TIG
#
# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.
#
# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
# Name :          #invertselection.rb 1.0
# Date :          8/7/5
# Type :          Tool                                
#-----------------------------------------------------------------------------

# This script will invert the current selection from the context menu.
# It will respect the nesting level if you are editing a group or component. 
# 

require 'sketchup.rb'

class InvertSelection_

 def InvertSelection_::validate ###
  model = Sketchup.active_model
  ss = model.selection 
  return nil if (ss.empty?)
  return true
 end

 def InvertSelection_::toggle 
  model = Sketchup.active_model
  ss = model.selection 
  objects = model.active_entities ### Everthing (in the current edit level). 
  objects.each {|o| 
    ss.toggle(o)                  ### Flip current selection set. 
    }
 end

end # Class 

if( not file_loaded?("#invertselection.rb") )

  UI.add_context_menu_handler do |menu|

    menu.add_separator if (InvertSelection_.validate)
    menu.add_item("ѡ") { InvertSelection_.toggle } if InvertSelection_.validate

  end

end

file_loaded "#invertselection.rb"

