# Name :          [CASF]DelCopEdges (v1.0)
# Description :   delete coplanar edges of a selection
# Author :        Carlos Antnio dos Santos Fal (carlosfale@sapo.pt)
# Usage :         select entities (not groups or components)
# Date :          Sep.2oo4
# Type :          tool

# -------------------------------------------------------------------------------------------------

class Copedges

  # level of selection
  @down_level = 2
  
  # validate the selection
  def Copedges::validate_selection

    sel = Sketchup.active_model.selection

    for ss in sel
      if ss.kind_of? Sketchup::Edge
	return true
      end
    end

    return false

  end

  # delete coplanar edges
  def Copedges::delete_coplanar_edges

    st = Time.new
    puts "DELETE COPLANAR EDGES - START"

    model = Sketchup.active_model
    model.start_operation "Delete Coplanar Edges"

    sel = model.selection
    if sel.length < @down_level
      @down_level = sel.length
    end

    ind = 0
    aux_count = 0
    while ind < sel.length
      if sel[ind].class == Sketchup::Edge
        if sel[ind].faces.length == 0
          sel[ind].erase!
          ind = ind - @down_level
	  aux_count = aux_count + 1
        elsif sel[ind].faces.length == 2
          if (sel[ind].faces[0].normal == sel[ind].faces[1].normal ||
	     sel[ind].faces[0].normal == Geom::Vector3d.linear_combination(-1, sel[ind].faces[1].normal, 1, [0, 0, 0])) &&
	     sel[ind].faces[0].material == sel[ind].faces[1].material
            sel[ind].erase!
	    ind = ind - @down_level
	    aux_count = aux_count + 1
          end
        end
      end
      ind = ind + 1
    end
    
    model.commit_operation

    et = Time.new
    puts "  EDGES DELETED = #{aux_count}"
    puts "DELETE COPLANAR EDGES - OK (#{et - st})"

  end

end  # Copedges

# -------------------------------------------------------------------------------------------------

if( not file_loaded?("DelCopEdges.rb"))
   UI.add_context_menu_handler do |menu|
      menu.add_separator if Copedges.validate_selection
      menu.add_item("ɾ  ") {Copedges.delete_coplanar_edges} if Copedges.validate_selection
   end
end

file_loaded("DelCopEdges.rb")