# Copyright 2005, @Last Software, Inc.

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------
# Name        :   Self Paced Tutorials Loader
# Description :   Adds menu items that allow the user to load installed
#                 SketchUp tutorial files.
# Menu Item   :   Help > Self Paced Tutorials > <filename>
# Context Menu:   N/A
# Usage       :   Select the file from the menu and that file is opened.
# Date        :   05/02/2002
# Type        :   Command
#-----------------------------------------------------------------------------
require 'sketchup.rb'
$:.push "C:/@Last/cvsroot/sketchup41/SketchUp/Plugins"

#load the script that hadlers the localaization methods
require 'LangHandler.rb'

if( not $self_paced_tutorials )
    $gsStrings = LanguageHandler.new("GettingStarted")

    mydir = File.dirname(__FILE__)

    tutorial_files = nil
    
    tutorial_files = Sketchup.find_support_files("skp", "Plugins/SelfPacedTutorials");
    
    if(tutorial_files.length > 0)
        help_menu = UI.menu("Help")
        #help_menu.add_separator
        
        tutorials_menu = help_menu.add_submenu($gsStrings.GetString("Self-Paced Tutorials"))

        tutorial_files.each do | filename |
            #s = tutorial_files[i].to_s
	    strDisplay = File.split(filename)[1]
	    
	    # strip out ugly parts of the file name
	    for i in 0..25
	    	chrnum=65+i
		strRemove="SPT-"+chrnum.chr+"_"
	    	strDisplay.gsub!(strRemove, "")
	    end
	    
	    strDisplay.gsub!(".skp", "")	  
	    strDisplay.gsub!("_", " ")	  
	    
            tutorials_menu.add_item(strDisplay) { 
                Sketchup.open_file(filename);
            }
        end
        
        tutorials_menu.add_separator
        
        tutorials_menu.add_item( $gsStrings.GetString("Get more tutorials") ) { UI.openURL("http://www.sketchup.com.cn") }
    
    end

    $self_paced_tutorials = true;
end    
