#this is the original SU box.rb,Decommented 
#obective use upto to generate an array of boxes 
require 'sketchup.rb'

def create_boxes
    
    prompts = ["Width", "Height", "Depth"]
    values = [6.feet, 1.feet, 3.feet]
    results = inputbox prompts, values, "Box Dimensions"
    width, height, depth = results
#-----------------------------------------------    
    model = Sketchup.active_model
    model.start_operation "Create Boxes"
    entities = model.active_entities
    group = entities.add_group
    entities = group.entities
    base = entities.add_face([0, 0, 0], [width, 0, 0], [width, depth, 0], [0, depth, 0])
    base.pushpull -height
    
#---------------------------------------------------- 
    prompts = [ "No. of Blocks Horiz.", "No. of Blocks Vert.", "Distance btw. Blocks"]
    values = [5, 5, 4.inch]
    results = inputbox prompts, values, "Boxes Array Size"
    h, v, dist = results

    0.upto(h-1) do |i|                   # Number of boxes across 
      x = (width*i)+(i*dist) 
      0.upto(v-1) do |j|                 # Number of boxes up 
        y = (depth*j)+(j*dist) 
        base = entities.add_face([x, y, 0], [x+width, y, 0], [x+width, y+depth, 0], [x, y+depth, 0])
        base.pushpull -height
       end
    end

  
    model.commit_operation
end

#if( not file_loaded?("boxes_array.rb") )
#   add_separator_to_menu("Plugins")
#   UI.menu("Plugins").add_item("Boxes") { create_boxes }
#end

#-----------------------------------------------------------------------------
file_loaded("boxes_array.rb")

