# CAMERA_PARAMETERS_1.rb
# Version of 09/07/04    1.0

# Copyright 2004 Envision 3D Limited

# Set camera parameters in sketchup

require 'sketchup.rb'

# Set camera parameters using viewpoint and target
def camera_vp_targ

    model = Sketchup.active_model
    view = model.active_view
    camera = view.camera

	# Get camera viewpoint and target
	eye = camera.eye
	vx = eye.x
	vy = eye.y
	vz = eye.z
	
	target = camera.target
	tx = target.x
	ty = target.y
	tz = target.z

	# fov property is VFOV not HFOV	
	vfovdeg = camera.fov

	# Viewport size
	w = Float(view.vpwidth)
	h = Float(view.vpheight)

	# Work out HFOV from VFOV and viewport size
	vfovrad = vfovdeg*Math::PI/180.0
	f = (h/2)/Math.tan(vfovrad/2.0)
	hfovrad = 2.0*Math.atan2((w/2),f)
	hfovdeg = hfovrad*180.0/Math::PI
	
	# Dialogue box
	prompts = ["Position X", "Position Y", "Position Z", "Mire X", "Mire Y", "Mire Z", "angle focal"]
	values = [vx, vy, vz, tx, ty, tz, hfovdeg]
    results = inputbox prompts, values, "Point de vue Camera / Mire"
    
    # Read back new values
    vx, vy, vz, tx, ty, tz, hfovdeg = results

	# New viewpoint and target
	eye.x = vx 
	eye.y = vy 
	eye.z = vz 
	
	target.x = tx
	target.y = ty
	target.z = tz

	# Up vector is straight up
	up = camera.up
	up.set!(0.0, 0.0, 1.0)
	
	# Set new parameters
    camera.set eye, target, up
    
	# Work out VFOV from HFOV and viewport size
	hfovrad = hfovdeg*Math::PI/180.0
	f = (w/2)/Math.tan(hfovrad/2.0)
	vfovrad = 2.0*Math.atan2((h/2),f)
	vfovdeg = vfovrad*180.0/Math::PI
    
    # Apply to camera
    camera.fov = vfovdeg
end 

# Set camera parameters using viewpoint, azimuth and elevation
def camera_vp_az_el

    model = Sketchup.active_model
    view = model.active_view
    camera = view.camera

	# Get camera viewpoint and target
	eye = camera.eye
	vx = eye.x
	vy = eye.y
	vz = eye.z
	
	target = camera.target
	tx = target.x
	ty = target.y
	tz = target.z
	
	# Work out azimuth and elevation angles
	if vx == tx && vy == ty then
		az = 0
		if vz > tz then
			el = -90.0
		else
			el = 90.0
		end
	else
	    az = Math.atan2(tx-vx,ty-vy)*180.0/Math::PI
	    if az < 0.0 then
	    	az = az+360.0
	    end

		el = Math.atan2((tz-vz),Math.sqrt((tx-vx)*(tx-vx)+(ty-vy)*(ty-vy)))*180.0/Math::PI
	end

	# fov property is VFOV not HFOV	
	vfovdeg = camera.fov

	# Viewport size
	w = Float(view.vpwidth)
	h = Float(view.vpheight)

	# Work out HFOV from VFOV and viewport size
	vfovrad = vfovdeg*Math::PI/180.0
	f = (h/2)/Math.tan(vfovrad/2.0)
	hfovrad = 2.0*Math.atan2((w/2),f)
	hfovdeg = hfovrad*180.0/Math::PI
	
	# Dialogue box
	prompts = ["Position X", "Position Y", "Position Z", "Azimuth", "Elevation", "Angle focal"]
	values = [vx, vy, vz, az, el, hfovdeg]
    results = inputbox prompts, values, "Point de vue Camera / Mire"
    
    # Read back new values
    vx, vy, vz, az, el, hfovdeg = results

	# New viewpoint
	eye.x = vx 
	eye.y = vy 
	eye.z = vz 
	
    # Work out the length of the viewpoint-target vector
    # but use 10 metres if it's presently zero.
	vdist = Math.sqrt((tx-vx)*(tx-vx)+(ty-vy)*(ty-vy)+(tz-vz)*(tz-vz))
	if vdist == 0.0 then
		vdist = 10.0
	end

    # Special case if elevation is straight up or down.
	if el >= 89.9 then
		tx = vx
		ty = vy
		tz = vz+vdist
	elsif el <= -89.9 then
		tx = vx
		ty = vy
		tz = vz-vdist

    # Otherwise calculate new target from azimuth and elevation.
	else
		vectx = Math.sin(az*Math::PI/180.0)
		vecty = Math.cos(az*Math::PI/180.0)
		vectz = Math.sqrt(vectx*vectx+vecty*vecty)*Math.tan(el*Math::PI/180.0)
		veclen = Math.sqrt(vectx*vectx+vecty*vecty+vectz*vectz)
	    tx = vx+vectx*vdist/veclen
	    ty = vy+vecty*vdist/veclen
	    tz = vz+vectz*vdist/veclen
	end	
	
	# New target position
	target.x = tx
	target.y = ty
	target.z = tz

	# Up vector is straight up
	up = camera.up
	up.set!(0.0, 0.0, 1.0)
	
	# Set new parameters
    camera.set eye, target, up
    
	# Work out VFOV from HFOV and viewport size
	hfovrad = hfovdeg*Math::PI/180.0
	f = (w/2)/Math.tan(hfovrad/2.0)
	vfovrad = 2.0*Math.atan2((h/2),f)
	vfovdeg = vfovrad*180.0/Math::PI
    
    # Apply to camera
    camera.fov = vfovdeg
end 



