# Copyright 2004, Todd Burch - Burchwood USA   http://www.burchwoodusa.com 

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

# Name :          centerpoint.rb 1.0
# Description :   Add a construction point to the center of a selected entity or group.
# Author :        Todd Burch   http://www.burchwoodusa.com 
# Usage :         1. Select the group, component or edge or face, etc.  If multiple entities are selected, 
#                    only the first item will be acted upon.  
#                 2. Run "Set Center Point" 
# Date :          03.Dec.2004
# Type :          Tool
# History:        1.0 (03.Dec.2004) - first version
#
#                                  
#-----------------------------------------------------------------------------
require 'sketchup.rb'

def addCenterPoint 
  center = Sketchup.active_model.selection[0].bounds.center 
  Sketchup.active_model.entities.add_cpoint(center) 
  end 

#=============================================================================

#if( not file_loaded?("centerpoint.rb") )
#    UI.menu("Plugins").add_item("Set Center Point") { addCenterPoint }
#end
#-----------------------------------------------------------------------------
file_loaded("centerpoint.rb")


