# Name :          Circle Slopes 1.0
# Description :   Create  Circle Slopes 
# Author :        ODM
# Web:            http://www.AITOP.com
#E-mail:          ODM@AITOP.com
# Usage :        Circle Slopes 1.0, use Plugins  Tools  options
# Date :          2.Sep.2oo4
# Type :          tool
# History:        1.0 ( 2.Sep.2oo4) - first version
#-----------------------------------------------------------------------------

require 'sketchup.rb'

def odm_aitop
        model=Sketchup.active_model
        entities=model.entities
	group = entities.add_group
        entities = group.entities
        prompts = ["Big Radius", "Small Radius","Height","Segments"]
        rotations=500.mm
        values = [1000.mm, 500.mm,500.mm, 24]
        results = inputbox prompts, values, "Circle Slopes Settings"
        return if not results    
        big_rad, sma_rad, pitch,segments = results
        center=[0,0,0]
        normal=[0,0,1]
        big_circle=entities.add_circle(center, normal, big_rad, segments) 
        sma_circle=entities.add_circle(center, normal, sma_rad, segments) 
        big_face=entities.add_face big_circle
        sma_face=entities.add_face sma_circle
        big_cir_ver = big_face.vertices 
        sma_cir_ver=sma_face.vertices
        sma_face.erase!
 	angle = 2*3.14159/segments
	bit_sma_z = pitch / segments
	num=1
	pts1=[]
	pts2=[]
	while num < (segments + 1)
		big_cur_x =big_rad * Math.cos(num * angle)
		big_cur_y = big_rad* Math.sin(num * angle)
		big_cur_z = num* bit_sma_z
		sma_cur_x = sma_rad * Math.cos(num * angle)
		sma_cur_y = sma_rad * Math.sin(num * angle)
		sma_cur_z = num * bit_sma_z
		pts1[pts1.length] = [big_cur_x,big_cur_y,big_cur_z]
		pts2[pts2.length] = [sma_cur_x,sma_cur_y,sma_cur_z]
		num += 1
	end
	curve1=entities.add_curve(pts1)
	curve2=entities.add_curve(pts2)
	lines0=[]
	lines1=[]
	lines2=[]
	lines3=[]
	0.upto(segments-1) do |a|
		lines0[lines1.length]=entities.add_line(pts1[a],pts2[a])
		entities[entities.length-1].find_faces
		lines0[a].smooth=true
		lines0[a].soft=true
		lines1[lines1.length]=entities.add_line(pts1[a],pts2[a+1])
		entities[entities.length-1].find_faces
		lines1[a].smooth=true
		lines1[a].soft=true
		lines2[lines2.length]=entities.add_line(pts1[-a],big_cir_ver[a])
		lines2[a].find_faces 
		lines2[a].smooth=true
		lines2[a].soft=true
		lines3[lines3.length]=entities.add_line(pts2[-a],sma_cir_ver[a])
		lines3[a].find_faces
		lines3[a].smooth=true
		lines3[a].soft=true
	end
	model.commit_operation
end

#-----------------------------------------------------------------------------

#if( not file_loaded?("aitop.rb") )
#    odm_menu=UI.menu("Puglins").add_submenu("AITOP Tools")
#        odm_menu.add_item("Circle Slopes 1.0") { odm_aitop }
#	odm_menu.add_item("About...") { UI.messagebox "Circle Slopes 1.0\nby ODM\n\nWelcome:\n http://www.aitop.com\n     odm@aitop.com"}
#end

#-----------------------------------------------------------------------------
file_loaded("aitop.rb")
