# Copyright 2004, David R. German (with generous support from others)

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#----------------------------------------------------------------------------

# Name : Cone Tool 1.1 (Beta)
# Description : A tool to create cones.
# Menu Item : Draw->Cone
# Usage : 1. Specify base diameter and height of cone.
# : 2. Click in model to select location of cone. (future version)
# Date : 8/29/2004
# Type : Tool
# ODM added create cone code 
# 8/30/2004
#----------------------------------------------------------------------------

require 'sketchup.rb'

#----------------------------------------------------------------------------

def create_cone
model = Sketchup.active_model
entities = model.active_entities
group = entities.add_group
entities = group.entities

model.start_operation "Create Cone" # Encapsulate a single UNDO operation.

prompts = ["Base Diameter ", "Height","Segments","posX", "posY", "posZ"] # Define prompts in the input box
values = [2000.mm, 2000.mm,24,0,0,0] # default values in the input box
results = inputbox prompts, values, "Cone Dimensions"
return if not results # This means that the user canceled the operation
base, height,segments,posx,posy,posz= results

#-----------------------------------------------------------------------------
# input specified values for the cone

center = [posx,posy,posz] # Center of cone base 
vector = [0,0,1] # Normal Vector 
radius = base/2 # Radius of cone base

#-----------------------------------------------------------------------------
# Draw circle for base of cone

cone_base = entities.add_circle(center, vector, radius, segments)

#-----------------------------------------------------------------------------
# Find_faces of circle 'cone_base' and call it 'face'

 face = entities.add_face(cone_base)

#-----------------------------------------------------------------------------
# create cone
vertices = face.vertices
cone_height=[posx,posy,posz+height]
#face1 = entities.add_face(center,cone_height,vertices[0])
face1 = entities.add_face(vertices[0],center,cone_height)

face1.followme cone_base
line1 = entities.add_line(vertices[0],vertices[12])
line1.find_faces 
line1.erase!
end

#-----------------------------------------------------------------------------
# Load 'Cone' into 'Draw' menu

#if( not file_loaded?("cone11.rb") )

# This will add a separator to the menu, but only once
#add_separator_to_menu("Draw")

# To add an item to a menu, you identify the menu, and then
# provide a title to display and a block to execute. In this case,
# the block just calls the create_box function
#UI.menu("Draw").add_item("Cone 1.1") { create_cone }

#end

#-----------------------------------------------------------------------------
file_loaded("cone11.rb")