# Name :          DELCO 1.5
# Description :   delete coplanar edges of a selection
# Author :        Carlos Antnio dos Santos Fal?(carlosfale@sapo.pt)
# Usage :         select entities (not groups or components)
# Date :          Sep.2oo4
# Type :          tool

# -------------------------------------------------------------------------------------------------

class Copedges

  # level of selection
  @down_level = 2
  
  # validate the selection
  def Copedges::validate_selection

    sel = Sketchup.active_model.selection

    for ss in sel
      if ss.kind_of? Sketchup::Edge
	return true
      end
    end

    return false

  end

  # delete coplanar edges
  def Copedges::delete_coplanar_edges

    model = Sketchup.active_model
    model.start_operation "Delete Coplanar Edges"

    sel = model.selection
    if sel.length < @down_level
      @down_level = sel.length
    end

    ind = 0
    while ind < sel.length
      if sel[ind].class == Sketchup::Edge
        if sel[ind].faces.length == 0
          sel[ind].erase!
          ind = ind - @down_level
        elsif sel[ind].faces.length == 2
          if sel[ind].faces[0].normal == sel[ind].faces[1].normal
            sel[ind].erase!
	    ind = ind - @down_level
          end
        end
      end
      ind = ind + 1
    end
    
    model.commit_operation

  end

end  # Copedges

# -------------------------------------------------------------------------------------------------

if( not file_loaded?("DELCO.rb"))
   UI.add_context_menu_handler do |menu|
#      menu.add_separator  if Copedges.validate_selection
      menu.add_item("ɾı ") {Copedges.delete_coplanar_edges} if Copedges.validate_selection
   end
end

file_loaded("DELCO.rb")