# Copyright 2004, Rick Wilson 

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

# Name :          exLines 1.0
# Description :   delete all construction lines from the model
# Author :        RW
# Usage :         select "Delete xLines" from the Plugins menu
# Date :          17.Feb.2005
# Type :		tool
# History:
#			1.0 (17.Feb.2005) - first version

require 'sketchup.rb'

def exLines
	model=Sketchup.active_model
	sel=model.selection
	ents=model.entities
	defs=model.definitions
	x=[]
	model.start_operation "exLines"
	count=0
	for e in ents
		if e.class==Sketchup::ConstructionLine
			x.push(e)
			count+=1
		end
	end
	for d in defs
		ents=d.entities
		for de in ents
			if de.class==Sketchup::ConstructionLine
				x.push(de) 
				count+=1
			end
		end
	end
	x.each {|xx| xx.erase!}
	model.commit_operation
	puts "Erased "+count.to_s+" construction lines."
end

#if( not file_loaded?("exLines.rb") )
#    add_separator_to_menu("Plugins")
#    UI.menu("Plugins").add_item("Delete xLines") { exLines }
#end

file_loaded("exLines.rb")

