# This script will install itself in the /plugins/ menu as "Hide All Unselected".  
# When executed, it will hide all objects that are not in the current selection.  
# All hiding operations are grouped as a single UNDO operation. 
# It does not support being in group or component edit mode.  If you have drilled 
# into a group or component and run this script, everything will hide.  
# 
#
# Author: Todd Burch 
#
require 'sketchup.rb' 
class Hide 

def Hide.insel(entity) 
  Sketchup.active_model.selection.each {|s| return true if (s == entity) }
  return false 
  end 

def Hide.hideAll 
  Sketchup.active_model.start_operation "Hide Unselected" 
  Sketchup.active_model.entities.each {|ae| ae.hidden = true if !(Hide.insel(ae)) } 

  Sketchup.active_model.commit_operation  
  end # hideAll 
end # Class 
 
#if( not file_loaded?("hideall1.rb") )
#   UI.menu("Plugins").add_item("Hide All Unselected") { Hide.hideAll }
#end
file_loaded("hideall1.rb")

