# Name :          hide_faces_edges.rb
# Description :   Hide and/or unhide faces and/or edges of the current selection
# Author :        Didier Bur
# Usage :         Select objects, select Selection:Hide/Unhide from the Context menu
# Type :          tool
# History:        2004,11,12
#-----------------------------------------------------------------------------
def hide_selected_edges
model = Sketchup.active_model
ss = model.selection
model.start_operation "Selection: Hide edges"
ss.each {|e| 
if e.typename == "Edge" and not e.hidden?
  e.hidden = true
end
}
model.commit_operation
end

def hide_selected_faces
model = Sketchup.active_model
ss = model.selection
model.start_operation "Selection: Hide faces"
ss.each {|e| 
if e.typename == "Face" and not e.hidden?
  e.hidden = true
end
}
model.commit_operation
end

def unhide_edges_faces
model = Sketchup.active_model
ents = model.entities
model.start_operation "Unhide edges and faces"
ents.each {|e| 
if e.typename == "Face" or e.typename == "Edge" and e.hidden?
  e.hidden = false
end
}
model.commit_operation
end

if( not file_loaded?("Scripts/HIDE_FACES_EDGES.RB") )
   UI.add_context_menu_handler do |menu|
      menu.add_separator
      menu.add_item("ѡ") { hide_selected_edges }
      menu.add_item("ѡ") { hide_selected_faces }
      menu.add_item("ʾصıߺ  ") { unhide_edges_faces }
  end
end
#-----------------------------------------------------------------------------
file_loaded("Scripts/HIDE_FACES_EDGES.RB")

