# Copyright 2004, Todd Burch - Burchwood USA   http://www.burchwoodusa.com 

# This software is a published work of Burchwood USA.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

# This software has not been endorsed or sanctioned by @Last Software.  Any comments, issues
# or concerns about this software or the affects of this software should be not directed to 
# @Last Software, but to Burchwood USA (www.burchwoodusa.com). 
#

# Name :          label_stray_lines.rb 1.0
# Description :   This script writes a text label on every line end that does not touch
#                 another line.  The text leader points to the tip of the open line or curve.
# Author :        Todd Burch   http://www.burchwoodusa.com 
# Usage :         1. select the part of a drawing that you want analyzed, or, select nothing 
#                 and the whole drawing will be analyzed. 
#                 2. Run "Label Stray Lines" from the Plugins menu.
# Date :          16.Sep.2004
# Type :          Imported Drawing Clean-Up Aid
# History:        1.0 (16.Sep.2004) - First version
#
#                                  
#-----------------------------------------------------------------------------

require 'sketchup.rb' 

class BadDrawing 

def BadDrawing.labelLines 
  allverts  = Array.new 
  lonepoints = Array.new 
  am = Sketchup.active_model        # Sketchup Active Model. 
  se = am.entities                  # Sketchup Entities. 
  ae = am.selection                 # Work with selection, if any... 
  if ae.length == 0 then ae = se end     # ...else work with whole model. 
  ae.each {|e| 
    if  e.class == Sketchup::Edge then   # If this is an edge...  
      e.vertices.each {|v|               # ...loop through its vertices... and 
        if v.edges.length == 1 then lonepoints << v.position end   # ...see if there is only 1 connected edge.
        }
      end   # if 
    } 
  print "There are ", lonepoints.length, " open line segments.\n" 
  am.start_operation "Label Stray Lines"        # Encapsulate into a single UNDO operation.
  i=1 
  lonepoints.each {|p| 
    se.add_text(i.to_s << " of " << lonepoints.length.to_s , p, [0,0,5] )    # Add the Text Label. 
    i+=1
    } 
  am.commit_operation                           # End of UNDO capsule. 
  end  # def 

#if not file_loaded?("label_stray_lines.rb") then   # Add the function to the Plugins Menu.
#  UI.menu("Plugins").add_item("Label Stray Lines") { BadDrawing.labelLines }
#  end
#file_loaded("label_stray_lines.rb")   # Mark the script loaded. 

end    # class 