#  VERSION 1.0
#
#
#
# Copyright 2004, Todd Burch - Burchwood USA   http://www.burchwoodusa.com 

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

# Name :          makefaces.rb 1.0
# Description :   Creates faces only on selected objects that could potentially receive as face.
# Author :        Todd Burch
# Usage :         1. select all elements for which you want a face.
#                 2. Run "Make Faces" from the Tools menu.
# Date :          17.Jul.2004
# Type :          Tool
# History:        1.0 (17.Jul.2004) - first version
#-----------------------------------------------------------------------------

require 'sketchup.rb'

#-----------------------------------------------------------------------------

# This routine creates faces from lines that make up closed section.
# If your ruby console is active, you will see how many faces were created.

def makeFaces
    model = Sketchup.active_model
    model.start_operation "Make Faces"
    print "makefaces.rb: Copyright 2004 Burchwood USA.\n" 
    #Get the current selection 
    ss = model.selection  
    print "makefaces.rb: There are ", ss.count, " selected items.\n"  # Anything & everything selected counts here.
    x = 0                       # accumulator 
    ss.each {|e|
      if e.typename == "Edge"   # find_faces only works on edges.
         y = e.find_faces       # This creates a face if it needs to be created.
         x = x + y              # If a face is added, 1 is added to x.
         end
      }     
    print "makefaces.rb: There were ", x, " face(s) added.\n"
    print "-----------------------------------------------\n" 

    end  
   
