# Copyright 2004, D. Bur,

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------
# Name        :   paint altitude faces
# Description :   A tool to paint a set of faces taking altitude into account
# Menu Item   :   Plugins -> Paint faces with altitude
# Context Menu:   NONE
# Author      :   Didier Bur
# Usage       :   Select faces,. Select menu Plugins/Paint faces with altitude
#             :   Choose base color and the number of different colors between lowest and highest altitudes
# Date        :   9/22/2004
# Type        :   Tool
#-----------------------------------------------------------------------------

def paint_faces_altitude
 
model = Sketchup.active_model
entities = model.active_entities
model.start_operation "paint altitude faces"
ss = model.selection

  if ss.empty? 
    UI.messagebox("No selection !")
    return nil
  end

  # Selection error checking: eliminates the non-face objects
  ss_remove = []
  i = 0
  j = 0
  0.upto( ss.length - 1) do |look|
    Sketchup.set_status_text("Selection errors checking, please wait..." )
    if( not ss[i].kind_of? Sketchup::Face )
      ss_remove[j] = ss[i]
      j = j + 1
    end
    i = i + 1
  end   #of upto

  if(j != 0)
    UI.messagebox( ss_remove.length.to_s + " object(s) of the selection aren't faces and will be ignored.")
    Sketchup.set_status_text("Removing ignored objects from selection, please wait..." )
    ss.remove( ss_remove )
    Sketchup.set_status_text("Removing ignored objects from selection, please wait...Done." )
  end

number_of_faces = ss.length.to_s

# User input values

all_colors = Sketchup::Color.names
enums = [all_colors.join("|")]

prompts = ["Base color  ", "Number of colors  "]
# default values in the input box
values = [@unique_color, 10]
results = inputbox prompts, values, enums, "Material parameters"

# User cancels
return if not results
# Otherwise
unique_color, number_of_colors = results

# bounding Z's of selection
k = 0
m = 0
n = 0
all_z = []
  0.upto( ss.length - 1) do |k|
    Sketchup.set_status_text("Retrieving min and max altitudes: "  + (k + 1).to_s + " / " + number_of_faces )
    vertices = ss[k].vertices
    0.upto( vertices.length - 1) do |m|
      pt = vertices[m].position
      all_z[n] = pt[2]
      n = n + 1
    end #of upto
  end #of upto
  z_max = all_z.max
  z_min = all_z.min
  delta_z = z_max - z_min
  slice_height = delta_z / number_of_colors
  
  UI.messagebox( number_of_faces.to_s + " objects in the selection.\n" + n.to_s + " Z checked.\n" + "Maxi Z: " + z_max.to_s + "\n" + "Mini Z: " + z_min.to_s + "\n" + "Delta Z: " + delta_z.to_s + "\n" + number_of_colors.to_s + " colors based on color: " + unique_color)
  
  # Prepare the materials
  color_step = (255 / number_of_colors).floor
  materials = model.materials 

  # Get the selected color RGB values
  base_color = Sketchup::Color.new unique_color
  r = base_color.red
  g = base_color.green
  b = base_color.blue
  r_prop = r / 255
  g_prop = g / 255
  b_prop = b / 255
  
  1.upto( number_of_colors ) do |ind|
    mat_name = "altitude_" + ind.to_s
    new_mat = materials.add(mat_name)
    #b = 0
    #g = 0
    #r = ind * color_step
    r = (r_prop * color_step * ind).floor
    g = (g_prop * color_step * ind).floor
    b = (b_prop * color_step * ind).floor
    color = Sketchup::Color.new(r,g,b)
    new_mat.color = color 
  end



# --------------------------------------------- Iterate through selection, face by face ?
i = 0
inf = 0
current_alt = 0.0

0.upto( ss.length - 1) do |paint|
  current_face = ss[i]
  # Verbose
  Sketchup.set_status_text("Painting face: "  + (i + 1).to_s + " / " + number_of_faces )
  edges = current_face.edges 
  vert = current_face.vertices
  # --------------------------------------------- Paint whith color ?
  all_z = []
  0.upto( vert.length - 1) do |k|
    pt = vert[k].position
    all_z[k] = pt[2]
  end #of upto
  z_max = all_z.max
  z_min = all_z.min
  # Average altitude of current face
  average_altitude = ((all_z[0] + all_z[1] + all_z[2]) / 3)
  # what slice ?
  current_slice = (average_altitude / slice_height).floor
  if(current_slice == 0) 
    current_slice = 1
  end
  if(current_slice > number_of_colors) 
    current_slice = number_of_colors
  end
  #Paint current face
  current_face.material = "altitude_" + current_slice.to_s
  
  # Next face
  i = i + 1
end #of upto
  model.commit_operation
end     #of def

#if( not file_loaded?("paint_altitude_faces.rb") )
#    add_separator_to_menu("Plugins")
#    UI.menu("Plugins").add_item("Paint altitude faces") { paint_faces_altitude }
#end
file_loaded("paint_altitude_faces.rb")
