#        Name : rooftool
# Description : builds 5 differents roofs shapes based on a quadrangular face
#      Author : Didier Bur
#       Usage : select face and select item in the Draw/Roofs menu          
#        Date : 21.Oct.2oo4
#        Type : tool

require 'sketchup.rb'

# translates a point p1 in the direction of p2-p3 with length d
# params are Point3d, 2 vertices, a length, returns a Point3d
def translate(p1, p2, p3, d)
   v = p3 - p2
   v.length = d
   trans = Geom::Transformation.translation(v)
   return p1.transform(trans)
end

#---Polar coordinates point
def translate_rotate_axis(p1, p2, p1axis, p2axis, d, angle)
   v = p2 - p1
   vaxis = p2axis - p1axis
   vec_axis = Geom::Vector3d.new(vaxis[0], vaxis[1], vaxis[2])
   v.length = d
   translate = Geom::Transformation.translation(v)
   p_temp = p1.transform(translate)
   #rotate = Geom::Transformation.rotation( p1, Geom::Vector3d.new(0,1,0),angle)
   rotate = Geom::Transformation.rotation( p1, vec_axis,angle)
   result = p_temp.transform(rotate)
   return result
end

#---Rotation definition for around Z axis
def translate_rotate_z(p1, p2, d, angle)
   v = p2 - p1
   v.length = d
   translate = Geom::Transformation.translation(v)
   p_temp = p1.transform(translate)
   rotate = Geom::Transformation.rotation( p1, Geom::Vector3d.new(0,0,1),angle)
   result = p_temp.transform(rotate)
   return result
end

# returns the mid point (Point3d) of two vertices
def mid( p1, p2 )
vec = p2.position - p1.position
return Geom::Point3d.new(p1.position.x + vec[0]/2, p1.position.y + vec[1]/2, p1.position.z + vec[2]/2)
end




#------------------------------------------------------------------------------------------------------
def make_ridge_roof

model = Sketchup.active_model
model.start_operation "Make ridge roof"
entities = model.active_entities
ss = model.selection

if ss.empty? 
  UI.messagebox("No selection.")
  return nil
end

# Selection error checking
if( ss.length > 1 )
  UI.messagebox( "Only one face allowed.")
  return nil
end
if( ss[0].typename != "Face")
  UI.messagebox( "The selected object is not a face.")
  return nil
end
if( ss[0].normal.z.to_i != 1 and ss[0].normal.z.to_i != -1 )
  UI.messagebox( "The selected face is not parallel to red-green plane.")
  return nil
end
if( ss[0].normal.z.to_i == 1 )
  ss[0].reverse!
end

loop = ss[0].outer_loop 
points = loop.vertices

if points.length != 4
  UI.messagebox( "Can't make a roof with such a face.")
  return nil
end

# sets the default setting
option = "Yes" if not option
slope = 30 if not slope
# Dialog box
  
options = ["Yes", "No"]
enums = [options.join("|")]
prompts = ["Along greater side  ", "Slope"]
values = [options, slope]
results = inputbox prompts, values, enums, "Roof parameters"

return if not results
option = results[0]
slope = results[1].to_f

if( slope == 90.0 )
UI.messagebox( "Invalid slope.")
  return nil
end

loop = ss[0].outer_loop 
points = loop.vertices

#which edge of the base is the greater ?
d_edge1 = points[0].position.distance points[1].position
d_edge2 = points[1].position.distance points[2].position
if( d_edge1 < d_edge2 )
  smallest_edge1 = [points[0], points[1]]
  smallest_edge2 = [points[2], points[3]]
  else
  smallest_edge1 = [points[1], points[2]]
  smallest_edge2 = [points[3], points[0]]
end

if( option == "Yes" )
  #along greater side
    #ends of ridge:
    mid_point1 = mid(smallest_edge1[0], smallest_edge1[1])
    mid_point2 = mid(smallest_edge2[0], smallest_edge2[1])
    #d = (mid_point1.distance smallest_edge1[0]) * 1.4142135
    #int1 = translate_rotate_z(smallest_edge1[0].position, mid_point1, d, -45.degrees)
    height = (mid_point1.distance smallest_edge1[0].position) * Math::tan(slope.degrees)
    ridge_1 = Geom::Point3d.new(mid_point1.x, mid_point1.y, mid_point1.z+height)
    ridge_2 = Geom::Point3d.new(mid_point2.x, mid_point2.y, mid_point2.z+height)
    #draw the faces
    Sketchup.active_model.active_entities.add_face(smallest_edge1[0].position, ridge_1, smallest_edge1[1])
    Sketchup.active_model.active_entities.add_face(smallest_edge2[0].position, ridge_2, smallest_edge2[1])
    Sketchup.active_model.active_entities.add_face(smallest_edge1[0].position, ridge_1, ridge_2, smallest_edge2[1])
    Sketchup.active_model.active_entities.add_face(smallest_edge1[1].position, ridge_1, ridge_2, smallest_edge2[0])
  else
  #along smaller side
  #ends of ridge:
    mid_point1 = mid(smallest_edge1[0], smallest_edge2[1])
    mid_point2 = mid(smallest_edge1[1], smallest_edge2[0])
    height = (mid_point1.distance smallest_edge1[0].position) * Math::tan(slope.degrees)
    ridge_1 = Geom::Point3d.new(mid_point1.x, mid_point1.y, mid_point1.z+height)
    ridge_2 = Geom::Point3d.new(mid_point2.x, mid_point2.y, mid_point2.z+height)
    Sketchup.active_model.active_entities.add_face(smallest_edge1[0].position, ridge_1, smallest_edge2[1].position)
    Sketchup.active_model.active_entities.add_face(smallest_edge1[1].position, ridge_2, smallest_edge2[0].position)
    Sketchup.active_model.active_entities.add_face(smallest_edge1[0].position, smallest_edge1[1].position, ridge_2, ridge_1, smallest_edge1[0].position)
    Sketchup.active_model.active_entities.add_face(smallest_edge2[0].position, smallest_edge2[1].position, ridge_1, ridge_2, smallest_edge2[0].position)
end


model.commit_operation
end    # of def

#------------------------------------------------------------------------------------------------------
def make_pavilion_roof

model = Sketchup.active_model
model.start_operation "Make pavilion roof"
entities = model.active_entities
ss = model.selection


if ss.empty? 
  UI.messagebox("No selection.")
  return nil
end

# Selection error checking
if( ss.length > 1 )
  UI.messagebox( "Only one face allowed.")
  return nil
end
if( ss[0].typename != "Face")
  UI.messagebox( "The selected object is not a face.")
  return nil
end
if( ss[0].normal.z.to_i != 1 and ss[0].normal.z.to_i != -1 )
  UI.messagebox( "The selected face is not parallel to red-green plane.")
  return nil
end
if( ss[0].normal.z.to_i == 1 )
  ss[0].reverse!
end

loop = ss[0].outer_loop 
points = loop.vertices

if points.length != 4
  UI.messagebox( "Can't make a roof with such a face.")
  return nil
end

# sets the default setting
slope = 30 if not slope
# Dialog box
prompts = ["Roof slope  "]
values = [slope]
results = inputbox prompts, values, "Roof parameter"
return if not results
slope = results[0].to_f

if( slope == 90.0 )
UI.messagebox( "Invalid slope.")
  return nil
end

loop = ss[0].outer_loop 
points = loop.vertices

# find the intersection of roof base
diag_1 = [points[0].position, points[2].position]
diag_2 = [points[1].position, points[3].position]
int = Geom.intersect_line_line(diag_1, diag_2)

#height of int point:
mid_point = mid(points[1], points[0])
d = mid_point.distance int 
height = d * Math::tan(slope.degrees)
p = Geom::Point3d.new(int.x, int.y, int.z+height)
#Sketchup.active_model.active_entities.add_cpoint p

#draw the faces
Sketchup.active_model.active_entities.add_face(points[0].position, p, points[1].position)
Sketchup.active_model.active_entities.add_face(points[1].position, p, points[2].position)
Sketchup.active_model.active_entities.add_face(points[2].position, p, points[3].position)
Sketchup.active_model.active_entities.add_face(points[3].position, p, points[0].position)
model.commit_operation
end    # of def


#------------------------------------------------------------------------------------------------------
def make_4_ridge_roof

model = Sketchup.active_model
model.start_operation "Make 4 sided ridge roof"
entities = model.active_entities
ss = model.selection


if ss.empty? 
  UI.messagebox("No selection.")
  return nil
end

# Selection error checking
if( ss.length > 1 )
  UI.messagebox( "Only one face allowed.")
  return nil
end
if( ss[0].typename != "Face")
  UI.messagebox( "The selected object is not a face.")
  return nil
end
if( ss[0].normal.z.to_i != 1 and ss[0].normal.z.to_i != -1 )
  UI.messagebox( "The selected face is not parallel to red-green plane.")
  return nil
end
if( ss[0].normal.z.to_i == 1 )
  ss[0].reverse!
end

loop = ss[0].outer_loop 
points = loop.vertices

if points.length != 4
  UI.messagebox( "Can't make a roof with such a face.")
  return nil
end

# sets the default setting
slope = 30 if not slope
# Dialog box
prompts = ["Roof slope  "]
values = [slope]
results = inputbox prompts, values, "Roof parameter"
return if not results
slope = results[0].to_f

if( slope == 90.0 )
UI.messagebox( "Invalid slope.")
  return nil
end

loop = ss[0].outer_loop 
points = loop.vertices

#which edge of the base is the greater ?
d_edge1 = points[0].position.distance points[1].position
d_edge2 = points[1].position.distance points[2].position
if( d_edge1 < d_edge2 )
  smallest_edge1 = [points[0], points[1]]
  smallest_edge2 = [points[2], points[3]]
  else
  smallest_edge1 = [points[1], points[2]]
  smallest_edge2 = [points[3], points[0]]
end

#first end of ridge:
mid_point1 = mid(smallest_edge1[1], smallest_edge1[0])
d = (mid_point1.distance smallest_edge1[0]) * 1.4142135
int1 = translate_rotate_z(smallest_edge1[0].position, mid_point1, d, -45.degrees)
height = (mid_point1.distance smallest_edge1[0].position) * Math::tan(slope.degrees)
p1 = Geom::Point3d.new(int1.x, int1.y, int1.z+height)

#second end of ridge:
mid_point2 = mid(smallest_edge2[1], smallest_edge2[0])
d = (mid_point2.distance smallest_edge2[0]) * 1.4142135
int2 = translate_rotate_z(smallest_edge2[0].position, mid_point2, d, -45.degrees)
height = (mid_point2.distance smallest_edge2[0]) * Math::tan(slope.degrees)
p2 = Geom::Point3d.new(int2.x, int2.y, int2.z+height)

#draw the faces
Sketchup.active_model.active_entities.add_face(smallest_edge1[0].position, smallest_edge1[1].position, p1, smallest_edge1[0].position)
Sketchup.active_model.active_entities.add_face(smallest_edge2[0].position, smallest_edge2[1].position, p2, smallest_edge2[0].position)

Sketchup.active_model.active_entities.add_face(smallest_edge1[1].position, smallest_edge2[0].position, p2, p1, smallest_edge1[1].position)
Sketchup.active_model.active_entities.add_face(smallest_edge2[1].position, smallest_edge1[0].position, p1, p2, smallest_edge2[1].position)

model.commit_operation
end    # of def

#-----------------------------------------------------------------------------
def make_hipped_end_roof

model = Sketchup.active_model
model.start_operation "Make hipped end roof"
entities = model.active_entities
ss = model.selection

# Selection error checking
if ss.empty? 
  UI.messagebox("No selection.")
  return nil
end
if( ss.length > 1 )
  UI.messagebox( "Only one face allowed.")
  return nil
end
if( ss[0].typename != "Face")
  UI.messagebox( "The selected object is not a face.")
  return nil
end
if( ss[0].normal.z.to_i != 1 and ss[0].normal.z.to_i != -1 )
  UI.messagebox( "The selected face is not parallel to red-green plane.")
  return nil
end
if( ss[0].normal.z.to_i == 1 )
  ss[0].reverse!
end
#----------------------------

loop = ss[0].outer_loop 
points = loop.vertices

if points.length != 4
  UI.messagebox( "Can't make a roof with such a face.")
  return nil
end

# sets the default setting
option = "Yes" if not option
slope = 30 if not slope
vertical = 100.cm if not vertical
# Dialog box
  
options = ["Along smallest side", "Along greatest side"]
enums = [options.join("|")]
prompts = ["Gable orientation  ", "Slope", "Gable height"]
values = [options, slope, vertical]
results = inputbox prompts, values, enums, "Roof parameters"

return if not results
option = results[0]
slope = results[1].to_f
vertical = results[2].to_l

if( slope == 90.0 )
UI.messagebox( "Invalid slope.")
  return nil
end

#which edge of the base is the greater ?
d_edge1 = points[0].position.distance points[1].position
d_edge2 = points[1].position.distance points[2].position
if( d_edge1 < d_edge2 )
  smallest_edge1 = [points[0], points[1]]
  smallest_edge2 = [points[2], points[3]]
  greatest_edge1 = [points[1], points[2]]
  greatest_edge2 = [points[3], points[0]]
  else
  smallest_edge1 = [points[1], points[2]]
  smallest_edge2 = [points[3], points[0]]
  greatest_edge1 = [points[2], points[3]]
  greatest_edge2 = [points[0], points[1]]
end

# another error checking
if( option == "Along greater side" )
  if( vertical > (([d_edge1, d_edge2].min / 2) * Math::tan(slope.degrees)) )
    UI.messagebox( "Incorrect gable height.")
    return nil
  end
  else
  if( vertical > (([d_edge1, d_edge2].max / 2) * Math::tan(slope.degrees)) )
    UI.messagebox( "Incorrect gable height.")
    return nil
  end
end

if( option == "Along smallest side" )
  #--------------------------------------------------------------------------------along greater side
    #ends of ridge:
    mid_point1 = mid(smallest_edge1[0], smallest_edge1[1])
    mid_point2 = mid(smallest_edge2[0], smallest_edge2[1])
    height = (mid_point1.distance smallest_edge1[0].position) * Math::tan(slope.degrees)
    ridge_1 = Geom::Point3d.new(mid_point1.x, mid_point1.y, mid_point1.z+height)
    ridge_2 = Geom::Point3d.new(mid_point2.x, mid_point2.y, mid_point2.z+height)
    hip_height = height - vertical
    #length, center and ends of vertical part
    d2 = hip_height / Math::tan(slope.degrees)
    up_mid_point1 = Geom::Point3d.new(mid_point1.x, mid_point1.y, mid_point1.z+ vertical)
    up_mid_point2 = Geom::Point3d.new(mid_point2.x, mid_point2.y, mid_point2.z+ vertical)
    end_up_11 = translate(up_mid_point1, smallest_edge1[0].position, smallest_edge1[1].position, d2)
    end_up_12 = translate(up_mid_point1, smallest_edge1[1].position, smallest_edge1[0].position, d2)
    end_up_21 = translate(up_mid_point2, smallest_edge2[0].position, smallest_edge2[1].position, d2)
    end_up_22 = translate(up_mid_point2, smallest_edge2[1].position, smallest_edge2[0].position, d2)
    up_1 = translate(up_mid_point1, smallest_edge1[0].position, smallest_edge2[1].position, d2)
    up_ridge_1 = Geom::Point3d.new(up_1.x, up_1.y, up_1.z+hip_height)
    up_2 = translate(up_mid_point2, smallest_edge2[0].position, smallest_edge1[1].position, d2)
    up_ridge_2 = Geom::Point3d.new(up_2.x, up_2.y, up_2.z+hip_height)
    
    #draw the vertical faces
    Sketchup.active_model.active_entities.add_face(smallest_edge1[0].position, smallest_edge1[1].position, end_up_11, end_up_12, smallest_edge1[0].position)
    Sketchup.active_model.active_entities.add_face(smallest_edge2[0].position, smallest_edge2[1].position, end_up_21, end_up_22, smallest_edge2[0].position)
    #draw the hipped ends faces
    Sketchup.active_model.active_entities.add_face(end_up_11, up_ridge_1, end_up_12, end_up_11)
    Sketchup.active_model.active_entities.add_face(end_up_21, up_ridge_2, end_up_22, end_up_21)
    #draw the inclined faces
    Sketchup.active_model.active_entities.add_face(smallest_edge1[0].position, end_up_12, up_ridge_1, up_ridge_2, end_up_21, smallest_edge2[1].position, smallest_edge1[0].position)
    Sketchup.active_model.active_entities.add_face(smallest_edge2[0].position, end_up_22, up_ridge_2, up_ridge_1, end_up_11, smallest_edge1[1].position, smallest_edge2[0].position)
  else
  #--------------------------------------------------------------------------------along smaller side
  #ends of ridge:
    #ends of ridge:
    mid_point1 = mid(greatest_edge1[0], greatest_edge1[1])
    mid_point2 = mid(greatest_edge2[0], greatest_edge2[1])
    mid_point3 = mid(smallest_edge1[0], smallest_edge1[1])
    mid_point4 = mid(smallest_edge2[0], smallest_edge2[1])
    height = ((smallest_edge1[0].position.distance smallest_edge1[1].position) / 2) - (vertical * Math::tan(slope.degrees))
    ridge_1 = Geom::Point3d.new(mid_point3.x, mid_point3.y, mid_point3.z+height)
    ridge_2 = Geom::Point3d.new(mid_point4.x, mid_point4.y, mid_point4.z+height)
    hip_height = height - vertical
    
    #length, center and ends of vertical part
    d2 = ((greatest_edge1[0].position.distance greatest_edge1[1].position) / 2) - (vertical / Math::tan(slope.degrees))
    up_mid_point1 = Geom::Point3d.new(mid_point1.x, mid_point1.y, mid_point1.z+ vertical)
    up_mid_point2 = Geom::Point3d.new(mid_point2.x, mid_point2.y, mid_point2.z+ vertical)
    end_up_11 = translate(up_mid_point1, greatest_edge1[0].position, greatest_edge1[1].position, d2)
    end_up_12 = translate(up_mid_point1, greatest_edge1[1].position, greatest_edge1[0].position, d2)
    end_up_21 = translate(up_mid_point2, greatest_edge2[0].position, greatest_edge2[1].position, d2)
    end_up_22 = translate(up_mid_point2, greatest_edge2[1].position, greatest_edge2[0].position, d2)
    
    up_1 = translate(mid_point3, greatest_edge1[0].position, greatest_edge1[1].position, (height / Math::tan(slope.degrees)))
    up_ridge_1 = Geom::Point3d.new(up_1.x, up_1.y, up_1.z+height)
    
    up_2 = translate(mid_point4, greatest_edge2[0].position, greatest_edge2[1].position, (height / Math::tan(slope.degrees)))
    up_ridge_2 = Geom::Point3d.new(up_2.x, up_2.y, up_2.z+height)
    #draw the vertical faces
    Sketchup.active_model.active_entities.add_face(greatest_edge1[0].position, greatest_edge1[1].position, end_up_11, end_up_12, greatest_edge1[0].position)
    Sketchup.active_model.active_entities.add_face(greatest_edge2[0].position, greatest_edge2[1].position, end_up_21, end_up_22, greatest_edge2[0].position)
    #draw the inclined faces
    Sketchup.active_model.active_entities.add_face(end_up_11, up_ridge_2, up_ridge_1, end_up_12, end_up_11)
    Sketchup.active_model.active_entities.add_face(end_up_21, up_ridge_1, up_ridge_2, end_up_22, end_up_21)
    #draw the hipped ends faces
    Sketchup.active_model.active_entities.add_face(greatest_edge1[0].position, greatest_edge2[1].position, end_up_21, up_ridge_1, end_up_12, greatest_edge1[0].position)
    Sketchup.active_model.active_entities.add_face(greatest_edge2[0].position, greatest_edge1[1].position, end_up_11, up_ridge_2, end_up_22, greatest_edge2[0].position)
    
end

model.commit_operation
end    # of def

#-----------------------------------------------------------------------------
def make_mansart_roof

model = Sketchup.active_model
model.start_operation "Make mansart roof"
entities = model.active_entities
ss = model.selection

#Selection error checking
if ss.empty? 
  UI.messagebox("No selection.")
  return nil
end
if( ss.length > 1 )
  UI.messagebox( "Only one face allowed.")
  return nil
end
if( ss[0].typename != "Face")
  UI.messagebox( "The selected object is not a face.")
  return nil
end
if( ss[0].normal.z.to_i != 1 and ss[0].normal.z.to_i != -1 )
  UI.messagebox( "The selected face is not parallel to red-green plane.")
  return nil
end
if( ss[0].normal.z.to_i == 1 )
  ss[0].reverse!
end  
#----------------------------

loop = ss[0].outer_loop 
points = loop.vertices

if points.length != 4
  UI.messagebox( "Can't make a roof with such a face.")
  return nil
end

# sets the default setting
option = "Yes" if not option
gable_height = 250.cm if not gable_height
slope_1 = 60 if not slope_1
slope_2 = 30 if not slope_2

# Dialog box
options = ["Along smallest side", "Along greatest side"]
enums = [options.join("|")]
prompts = ["Gable orientation  ", "Gable height", "Slope 1", "Slope 2"]
values = [options, gable_height, slope_1, slope_2]
results = inputbox prompts, values, enums, "Roof parameters"

return if not results
option = results[0]
gable_height = results[1].to_f
slope_1 = results[2].to_f
slope_2 = results[3].to_f
vertical = results[2].to_l

if( slope_1 == 90.0 ) or ( slope_2 == 90.0 ) or ( slope_1 == 0.0 ) or ( slope_2 == 0.0 )
UI.messagebox( "Invalid slope.")
  return nil
end

#which edge of the base is the greater ?
d_edge1 = points[0].position.distance points[1].position
d_edge2 = points[1].position.distance points[2].position
if( d_edge1 < d_edge2 )
  smallest_edge1 = [points[0], points[1]]
  smallest_edge2 = [points[2], points[3]]
  greatest_edge1 = [points[1], points[2]]
  greatest_edge2 = [points[3], points[0]]
  else
  smallest_edge1 = [points[1], points[2]]
  smallest_edge2 = [points[3], points[0]]
  greatest_edge1 = [points[2], points[3]]
  greatest_edge2 = [points[0], points[1]]
end

if( option == "Along smallest side" )
  #along smallest side
  #draw the gable profile
  mid_point1 = mid(smallest_edge1[0], smallest_edge1[1])
  mid_point2 = mid(smallest_edge2[0], smallest_edge2[1])
  ridge_1 = Geom::Point3d.new(mid_point1.x, mid_point1.y, mid_point1.z+gable_height)
  half_width = (smallest_edge1[0].position.distance smallest_edge1[1].position) / 2
  h1 = half_width * Math::tan(slope_1.degrees)
  high_p = Geom::Point3d.new(mid_point1.x, mid_point1.y, mid_point1.z+h1)
  d1 = gable_height / Math::tan(slope_2.degrees)
  low_p1 = translate(mid_point1, smallest_edge1[0].position, smallest_edge1[1].position, d1)
  low_p2 = translate(mid_point1, smallest_edge1[1].position, smallest_edge1[0].position, d1)
  int1 = Geom.intersect_line_line([high_p, smallest_edge1[1].position,], [ridge_1 , low_p1]) 
  int2 = Geom.intersect_line_line([high_p, smallest_edge1[0].position,], [ridge_1 , low_p2])
  #Error checking
  if(int1.z < ridge_1.z) and (int1.z > mid_point1.z)
    profile = Sketchup.active_model.active_entities.add_face(smallest_edge1[0].position, smallest_edge1[1].position, int1, ridge_1, int2, smallest_edge1[0].position)
    profile.pushpull -(greatest_edge1[0].position.distance greatest_edge1[1].position)
    else
      UI.messagebox( "No Mansart roof possible with these data.")
  end
  else
    #along greatest side
    #draw the gable profile
    mid_point1 = mid(greatest_edge1[0], greatest_edge1[1])
    mid_point2 = mid(greatest_edge2[0], greatest_edge2[1])
    ridge_1 = Geom::Point3d.new(mid_point1.x, mid_point1.y, mid_point1.z+gable_height)
    half_width = (greatest_edge1[0].position.distance greatest_edge1[1].position) / 2
    h1 = half_width * Math::tan(slope_1.degrees)
    high_p = Geom::Point3d.new(mid_point1.x, mid_point1.y, mid_point1.z+h1)
    d1 = gable_height / Math::tan(slope_2.degrees)
    low_p1 = translate(mid_point1, greatest_edge1[0].position, greatest_edge1[1].position, d1)
    low_p2 = translate(mid_point1, greatest_edge1[1].position, greatest_edge1[0].position, d1)
    int1 = Geom.intersect_line_line([high_p, greatest_edge1[1].position,], [ridge_1 , low_p1]) 
    int2 = Geom.intersect_line_line([high_p, greatest_edge1[0].position,], [ridge_1 , low_p2])
    #Error checking
    if(int1.z < ridge_1.z) and (int1.z > mid_point1.z)
    profile = Sketchup.active_model.active_entities.add_face(greatest_edge1[0].position, greatest_edge1[1].position, int1, ridge_1, int2, greatest_edge1[0].position)
    profile.pushpull -(smallest_edge1[0].position.distance smallest_edge1[1].position)
    else
      UI.messagebox( "No Mansart roof possible with these data.")
  end
end


end #of def

#-----------------------------------------------------------------------------
if( not file_loaded?("rooftools.rb") )
    add_separator_to_menu("Draw")
    utilities_menu = UI.menu("Draw").add_submenu("޽ݶ")
      utilities_menu.add_item("ɽݶ") { make_ridge_roof }
      utilities_menu.add_item("ܼʽݶ") { make_pavilion_roof }
      utilities_menu.add_item("бЪɽݶ") { make_4_ridge_roof }
      utilities_menu.add_item("Ъɽݶ") { make_hipped_end_roof }
      utilities_menu.add_item("ʽݶ") { make_mansart_roof }
      
end

#-----------------------------------------------------------------------------
file_loaded("rooftools.rb")