#        Name : Rotix 1.1
# Description : rotate objects with 90, custom and random degrees
#      Author : TBD
#       Usage : select from the Plugins menu, hover mouse over object (SHIFT to add to current selection)
#               and use left/right for 90 degrees, up/down to rotate with VCB value, left click to random rotate
#        Date : 25.Jul.2oo4
#        Type : tool
#    Modified : 19.Aug.2004 by Glenn M. Lewis - hit 'Home' or 'End' key to change the axis of rotation

class Rotix

  # initialize on tool activation
  def activate
    @entities = []
    # show VCB and status info
    Sketchup::set_status_text("Rotix::left/right for 90 degrees, up/down for VCB value, enter to random, Home/End to change axis", SB_PROMPT)
    Sketchup::set_status_text("Z:Angle", SB_VCB_LABEL)
    @v = Geom::Vector3d.new(0,0,1)
    # default value
    @angle = 5
    @add_selection = 0
  end

  def change_axis_up
    if @v.z == 1
      Sketchup::set_status_text("X:Angle", SB_VCB_LABEL)
      @v = Geom::Vector3d.new(1,0,0)
    elsif @v.x == 1
      Sketchup::set_status_text("Y:Angle", SB_VCB_LABEL)
      @v = Geom::Vector3d.new(0,1,0)
    else
      Sketchup::set_status_text("Z:Angle", SB_VCB_LABEL)
      @v = Geom::Vector3d.new(0,0,1)
    end
  end
  
  def change_axis_down
    if @v.z == 1
      Sketchup::set_status_text("Y:Angle", SB_VCB_LABEL)
      @v = Geom::Vector3d.new(0,1,0)
    elsif @v.x == 1
      Sketchup::set_status_text("Z:Angle", SB_VCB_LABEL)
      @v = Geom::Vector3d.new(0,0,1)
    else
      Sketchup::set_status_text("X:Angle", SB_VCB_LABEL)
      @v = Geom::Vector3d.new(1,0,0)
    end
  end
  
  #perform rotation
  def rotate(angle)
    ss= Sketchup.active_model.selection
    ss.each do |e|  
      pt = e.bounds.center
      tr = Geom::Transformation.rotation(pt,@v,angle.degrees)
      Sketchup.active_model.active_entities.transform_entities(tr,e)
    end
  end

  # on MouseMove perform selection
  def onMouseMove(flags, x, y, view)  
    Sketchup::set_status_text("#{@angle}", SB_VCB_VALUE)
    ph = view.pick_helper
    found = ph.do_pick(x,y)
    picked = ph.best_picked 

    if (picked != nil)
      # do not add edges/faces to selection
      if (!picked.kind_of? Sketchup::Edge and !picked.kind_of? Sketchup::Face)
	Sketchup.active_model.selection.add(picked) if (picked != @entities)
	@entities = picked
      end
    else
      if @add_selection == 0
	Sketchup.active_model.selection.clear
	@entities = nil
      end
    end
  end
  
  # random rotate
  def onLButtonDown(flags, x, y, view) 
    @angle = rand(360)
    # update the VCB value
    Sketchup::set_status_text("#{@angle}", SB_VCB_VALUE)
    rotate(@angle)
  end
  
  # if SHIFT is released back to normal selection (on mouse hover)
  def onKeyUp(key, repeat, flags, view)
    @add_selection = 0 if key == CONSTRAIN_MODIFIER_KEY
  end
  
  # process keyboard
  def onKeyDown(key, repeat, flags, view)
    case key
    when VK_LEFT then rotate(90)
    when VK_RIGHT then rotate(-90)
    when VK_UP then rotate(-@angle)
    when VK_DOWN then rotate(@angle)
    when VK_HOME then change_axis_up
    when VK_END then change_axis_down
    when CONSTRAIN_MODIFIER_KEY then @add_selection = 1 if (repeat == 1)
    end
  end
  
  # on user text in VCB modify angle
  def onUserText(text,view)
    begin
      value = text.to_i
    rescue
      # Error parsing the text
      UI.beep
      value = nil
      Sketchup::set_status_text "", SB_VCB_VALUE
    end
    return if !value
    
    @angle = value
  end

end # class Rotix

#----------------------------------------------------------------------------
# add menu items
#if( not $rotix_menu_loaded )
#  add_separator_to_menu("Plugins")
#  UI.menu("Plugins").add_item("[TBD] Rotix") { Sketchup.active_model.select_tool Rotix.new }
#end

#$rotix_menu_loaded = true 
