#        Name : Selecto 1.2
# Description : select edges on mouse drag
#      Author : TBD
#       Usage : select from the Plugins menu, drag over edges to select
#        Date : 30.Aug.2oo4
#        Type : tool
#      History: 1.2 (31.Aug.2oo4) - drag to toggle, SHIFT+hover to add to selection
#               1.1 (30.Aug.2oo4) - added support for SHIFT - toggle selected edge
#               1.o (30.Aug.2oo4) - first version


class Selecto
   # initialize on tool activation
   def activate
      @entities = []
      @toggle_selection = 0
      # show info
      Sketchup::set_status_text("Selecto::click+drag mouse to toggle edge selection, hold SHIFT to add", SB_PROMPT)
   end

   # on MouseMove perform selection
   def onMouseMove(flags, x, y, view)  
      ph = view.pick_helper
      found = ph.do_pick(x,y)
      picked = ph.best_picked 

      puts @toggle_selection,"\n"
      if (picked != nil)
         # do not add edges/faces to selection
         if (picked.kind_of? Sketchup::Edge)
            case @toggle_selection
               when 1 then Sketchup.active_model.selection.add(picked) if (picked != @entities)
               when 2 then Sketchup.active_model.selection.toggle(picked) if (picked != @entities)
            end            
            @entities = picked
         end
      end
   end

   def onLButtonDown(flags, x, y, view)
      @toggle_selection = 2 if @toggle_selection != 1
   end

   def onLButtonUp(flags, x, y, view)
      @toggle_selection = 0
   end

   # if SHIFT is released back to normal selection (on mouse hover)
   def onKeyUp(key, repeat, flags, view)
      @toggle_selection = 0 if key == CONSTRAIN_MODIFIER_KEY
   end
   
   # process keyboard
   def onKeyDown(key, repeat, flags, view)
      @toggle_selection = 1 if ((repeat == 1) && (key == CONSTRAIN_MODIFIER_KEY))
   end

end
#----------------------------------------------------------------------------
# add menu items
#if( not $selecto_menu_loaded )
#    add_separator_to_menu("Plugins")
#    UI.menu("Plugins").add_item("[TBD] Selecto") { Sketchup.active_model.select_tool Selecto.new }
#end
  
$selecto_menu_loaded = true 